/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.query.impl;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import uk.ac.ebi.uniprot.dataservice.query.Query;
import uk.ac.ebi.uniprot.dataservice.query.impl.CompositeQuery;
import uk.ac.ebi.uniprot.dataservice.query.impl.EmptyQuery;
import uk.ac.ebi.uniprot.dataservice.query.impl.EverythingQuery;

enum QueryOp {
    AND,
    OR;


    public static Query and(Query ... subQueries) {
        if (subQueries.length == 0) {
            throw new IllegalArgumentException("No queries provided for and()");
        }
        if (Stream.of(subQueries).anyMatch(f -> f.isEmpty())) {
            return EmptyQuery.getInstance();
        }
        List<Query> collect = Stream.of(subQueries).filter(f -> !f.isEverything()).collect(Collectors.toList());
        return QueryOp.joinQueries(AND, collect);
    }

    public static Query or(Query ... subQueries) {
        if (Stream.of(subQueries).anyMatch(f -> f.isEverything())) {
            return EverythingQuery.getInstance();
        }
        List<Query> collect = Stream.of(subQueries).filter(f -> !f.isEmpty()).collect(Collectors.toList());
        if (subQueries.length == 0) {
            throw new IllegalArgumentException("No queries provided for or()");
        }
        return QueryOp.joinQueries(OR, collect);
    }

    private static Query joinQueries(QueryOp logicalOp, List<Query> subQueries) {
        Query query;
        if (subQueries.size() == 0) {
            query = EmptyQuery.getInstance();
        } else if (subQueries.size() == 1) {
            query = subQueries.get(0);
        } else {
            CompositeQuery compositeQuery = new CompositeQuery(logicalOp, subQueries);
            query = compositeQuery;
        }
        return query;
    }
}

