/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.query.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.uniprot.dataservice.query.Query;
import uk.ac.ebi.uniprot.dataservice.query.impl.AbstractQuery;
import uk.ac.ebi.uniprot.dataservice.query.impl.EmptyQuery;
import uk.ac.ebi.uniprot.dataservice.query.impl.EverythingQuery;
import uk.ac.ebi.uniprot.dataservice.query.impl.PhraseQuery;
import uk.ac.ebi.uniprot.dataservice.query.impl.QueryOp;

public class CompositeQuery
implements Query {
    public QueryOp connecion;
    private List<Query> nodes = new ArrayList<Query>();

    private CompositeQuery() {
    }

    public CompositeQuery(QueryOp connecion, List<Query> nodes) {
        this.connecion = connecion;
        this.nodes.addAll(nodes);
    }

    @Override
    public Query and(Query condition) {
        if (condition.isEmpty()) {
            return EmptyQuery.getInstance();
        }
        if (condition.isEverything()) {
            return this;
        }
        if (this.isEmpty()) {
            return this;
        }
        if (this.isEverything()) {
            return condition;
        }
        if (this.connecion == QueryOp.AND) {
            CompositeQuery duplicate = this.duplicate();
            if (condition instanceof AbstractQuery) {
                duplicate.nodes.add(condition);
            } else {
                CompositeQuery condi = (CompositeQuery)condition;
                if (condi.connecion == QueryOp.AND) {
                    duplicate.nodes.addAll(condi.nodes);
                } else {
                    duplicate.nodes.add(condition);
                }
            }
            return duplicate;
        }
        CompositeQuery compositeQueryCondition = new CompositeQuery(QueryOp.AND, Arrays.asList(this, condition));
        return compositeQueryCondition;
    }

    @Override
    public Query or(Query condition) {
        if (condition.isEmpty()) {
            return this;
        }
        if (condition.isEverything()) {
            return EverythingQuery.getInstance();
        }
        if (this.isEmpty()) {
            return condition;
        }
        if (this.isEverything()) {
            return this;
        }
        if (this.connecion == QueryOp.OR) {
            CompositeQuery duplicate = this.duplicate();
            if (condition instanceof AbstractQuery) {
                duplicate.nodes.add(condition);
            } else {
                CompositeQuery condi = (CompositeQuery)condition;
                if (condi.connecion == QueryOp.OR) {
                    duplicate.nodes.addAll(condi.nodes);
                } else {
                    duplicate.nodes.add(condition);
                }
            }
            return duplicate;
        }
        CompositeQuery compositeQueryCondition = new CompositeQuery(QueryOp.OR, Arrays.asList(this, condition));
        return compositeQueryCondition;
    }

    @Override
    public Query not() {
        if (this.isEverything()) {
            return EmptyQuery.getInstance();
        }
        if (this.isEmpty()) {
            return EverythingQuery.getInstance();
        }
        QueryOp newconn = this.connecion == QueryOp.AND ? QueryOp.OR : QueryOp.AND;
        CompositeQuery duplicate = new CompositeQuery(newconn, this.nodes.stream().map(node -> node.not()).collect(Collectors.toList()));
        return duplicate;
    }

    @Override
    public String getQueryString() {
        StringBuilder sb = new StringBuilder();
        Query queryNode = this.nodes.get(0);
        boolean isBasic = queryNode instanceof AbstractQuery;
        sb.append(isBasic ? "" : "(");
        sb.append(queryNode.getQueryString());
        sb.append(isBasic ? "" : ")");
        if (this.nodes.size() > 1) {
            for (int i = 1; i < this.nodes.size(); ++i) {
                Query query = this.nodes.get(i);
                sb.append(" ");
                sb.append(this.connecion.toString());
                sb.append(" ");
                isBasic = query instanceof PhraseQuery;
                sb.append(isBasic ? "" : "(");
                sb.append(query.getQueryString());
                sb.append(isBasic ? "" : ")");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean isEmpty() {
        if (this.connecion == QueryOp.AND) {
            return this.nodes.stream().anyMatch(f -> f.isEmpty());
        }
        return false;
    }

    @Override
    public boolean isEverything() {
        if (this.connecion == QueryOp.OR) {
            return this.nodes.stream().anyMatch(f -> f.isEverything());
        }
        return false;
    }

    private CompositeQuery duplicate() {
        CompositeQuery compositeQueryCondition = new CompositeQuery(this.connecion, this.nodes);
        return compositeQueryCondition;
    }

    public String toString() {
        return this.getQueryString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.connecion == null ? 0 : this.connecion.hashCode());
        result = 31 * result + (this.nodes == null ? 0 : this.nodes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeQuery other = (CompositeQuery)obj;
        if (this.connecion != other.connecion) {
            return false;
        }
        return !(this.nodes == null ? other.nodes != null : !this.nodes.equals(other.nodes));
    }
}

