/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.domain.variants;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.uniprot.dataservice.domain.variants.VariantObject;

@Deprecated
public class VariantFFParser
implements Iterator<VariantObject>,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(VariantFFParser.class);
    private static final int INDEX_ACCESSION = 0;
    private static final int INDEX_BEGIN = 1;
    private static final int INDEX_CYTOBAND = 2;
    private static final int INDEX_GENOMIC_LOC = 3;
    private static final int INDEX_CONSEQUENCE_TYPE = 4;
    private static final int INDEX_END = 5;
    private static final int INDEX_WILDTYPE = 6;
    private static final int INDEX_MUTATION = 7;
    private static final int INDEX_FREQ = 8;
    private static final int INDEX_POLYPHEN_PRED = 9;
    private static final int INDEX_POLYPHEN_SCORE = 10;
    private static final int INDEX_SIFT_PRED = 11;
    private static final int INDEX_SIFT_SCORE = 12;
    private static final int INDEX_SOMATIC_STATUS = 13;
    private static final int INDEX_ASSOC = 14;
    private static final int INDEX_CLINICAL_SIG = 15;
    private static final int INDEX_DESCRIPTION = 16;
    private static final int INDEX_SOURCE_IDS = 17;
    private static final int INDEX_ISSP = 18;
    private static final int INDEX_DISEASE = 19;
    private static final int INDEX_EVIDENCES = 20;
    private static final String ACCESSION = "ACCESSION";
    private final BufferedReader bufferedReader;
    private String line;

    public VariantFFParser(String filename) throws IOException {
        FileReader fileInputStream = new FileReader(filename);
        this.bufferedReader = new BufferedReader(fileInputStream);
        this.line = this.bufferedReader.readLine();
        if (this.line.startsWith(ACCESSION)) {
            this.line = this.bufferedReader.readLine();
        }
    }

    @Override
    public boolean hasNext() {
        return this.line != null;
    }

    @Override
    public VariantObject next() {
        Preconditions.checkState((this.line != null ? 1 : 0) != 0, (Object)"The line string cannot be null while calling with a Iterator.");
        try {
            String currentLine = this.line;
            this.line = this.bufferedReader.readLine();
            return this.parseLineCatchException(currentLine);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private VariantObject parseLineCatchException(String line) {
        try {
            return VariantFFParser.parseLine(line);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOGGER.error("Error Parsing Line: {}", (Object)line);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static VariantObject parseLine(String line) {
        String[] sourceIds;
        String[] associations;
        String[] variantFields = line.split("\t");
        VariantObject variantObject = new VariantObject();
        variantObject.setRawString(line);
        variantObject.setAccession(VariantFFParser.parseBasicField(variantFields[0].trim()));
        variantObject.setBegin(VariantFFParser.parseInt(variantFields[1].trim()));
        variantObject.setCytogeneticband(VariantFFParser.parseBasicField(variantFields[2].trim()));
        variantObject.setGenomiclocation(VariantFFParser.parseBasicField(variantFields[3].trim()));
        variantObject.setConsequencetype(VariantFFParser.parseBasicField(variantFields[4].trim()));
        variantObject.setEnd(VariantFFParser.parseInt(variantFields[5].trim()));
        variantObject.setWildtype(VariantFFParser.parseBasicField(variantFields[6].trim()));
        variantObject.setMutatedtype(VariantFFParser.parseBasicField(variantFields[7].trim()));
        variantObject.setFrequency(VariantFFParser.parseFloat(variantFields[8].trim()));
        variantObject.setPolyphenprediction(VariantFFParser.parseBasicField(variantFields[9].trim()));
        variantObject.setPolyphenscore(VariantFFParser.parseDouble(variantFields[10].trim()));
        variantObject.setSiftprediction(VariantFFParser.parseBasicField(variantFields[11].trim()));
        variantObject.setSiftscore(VariantFFParser.parseDouble(variantFields[12].trim()));
        variantObject.setSomaticstatus(VariantFFParser.parseInt(variantFields[13].trim()));
        variantObject.setClinicalsignificance(VariantFFParser.parseBasicField(variantFields[15].trim()));
        variantObject.setDescription(VariantFFParser.parseBasicField(variantFields[16].trim()));
        String associationField = VariantFFParser.parseBasicField(variantFields[14].trim());
        if (associationField != null && (associations = VariantFFParser.parseStringArray(associationField)) != null) {
            ArrayList<VariantObject.RawAssociation> assArr = new ArrayList<VariantObject.RawAssociation>();
            for (String ass : associations) {
                if (ass == null) continue;
                assArr.add(VariantFFParser.parseAssociation(ass));
            }
            variantObject.setAssociations(assArr.toArray(new VariantObject.RawAssociation[assArr.size()]));
        }
        if ((sourceIds = VariantFFParser.parseArray(VariantFFParser.parseBasicField(variantFields[17].trim()))) != null) {
            ArrayList<VariantObject.RawEvidence> sourceIdsArr = new ArrayList<VariantObject.RawEvidence>();
            for (String sourceId : sourceIds) {
                if (sourceId == null || sourceId.equals("-")) continue;
                sourceIdsArr.add(VariantFFParser.parseSourceId(sourceId));
            }
            variantObject.setSourceid(sourceIdsArr.toArray(new VariantObject.RawEvidence[sourceIdsArr.size()]));
        }
        variantObject.setIssp(VariantFFParser.parseInt(VariantFFParser.parseBasicField(variantFields[18].trim())));
        variantObject.setDisease(VariantFFParser.parseInt(VariantFFParser.parseBasicField(variantFields[19].trim())));
        String[] evidenceIdsArr = VariantFFParser.parseArray(VariantFFParser.parseBasicField(variantFields[20].trim()));
        if (evidenceIdsArr != null) {
            ArrayList<VariantObject.RawEvidence> evidences = new ArrayList<VariantObject.RawEvidence>();
            for (String string : evidenceIdsArr) {
                if (string == null || string.equals("-")) continue;
                evidences.add(VariantFFParser.parseEvidence(string));
            }
            variantObject.setEvidence(evidences.toArray(new VariantObject.RawEvidence[evidences.size()]));
        }
        Preconditions.checkState((variantObject.getBegin() != 0 ? 1 : 0) != 0, (Object)variantObject.getRawString());
        return variantObject;
    }

    private static String[] parseStringArray(String ss) {
        return ss.split("\",\"");
    }

    public static VariantObject.RawEvidence parseEvidence(String string) {
        VariantObject.RawEvidence evidence = new VariantObject.RawEvidence();
        String[] evidenceArr = string.split(" ");
        evidence.setDatabase(evidenceArr[0]);
        evidence.setDbId(evidenceArr[1]);
        evidence.setEco(evidenceArr[2]);
        return evidence;
    }

    public static VariantObject.RawEvidence parseSourceId(String string) {
        VariantObject.RawEvidence evidence = new VariantObject.RawEvidence();
        String[] evidenceArr = string.split(" ");
        evidence.setDatabase(evidenceArr[0]);
        evidence.setDbId(evidenceArr[1]);
        return evidence;
    }

    public static VariantObject.RawAssociation parseAssociation(String string) {
        VariantObject.RawAssociation association = new VariantObject.RawAssociation();
        String[] associationArr = string.split("\" \"");
        association.setName(VariantFFParser.parseBasicField(VariantFFParser.stripQuotes(associationArr[0])));
        association.setDescription(VariantFFParser.parseBasicField(VariantFFParser.stripQuotes(associationArr[1])));
        association.setSourceType(VariantFFParser.parseBasicField(VariantFFParser.stripQuotes(associationArr[2])));
        association.setSourceId(VariantFFParser.parseBasicField(VariantFFParser.stripQuotes(associationArr[3])));
        association.setECO(VariantFFParser.parseBasicField(VariantFFParser.stripQuotes(associationArr[4])));
        return association;
    }

    public static String stripQuotes(String s) {
        boolean stripStart = s.startsWith("\"");
        boolean stripEnd = s.endsWith("\"");
        if (!stripStart && !stripEnd) {
            return s;
        }
        return s.substring(stripStart ? 1 : 0, stripEnd ? s.length() - 1 : s.length());
    }

    public static String[] parseArray(String s) {
        if (s == null) {
            return null;
        }
        String[] split = s.split(",");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].trim();
        }
        return split;
    }

    public static int parseInt(String s) {
        String field = VariantFFParser.parseBasicField(s);
        if (field != null) {
            return Integer.parseInt(field);
        }
        return 0;
    }

    public static float parseFloat(String s) {
        String field = VariantFFParser.parseBasicField(s);
        if (field != null) {
            return Float.parseFloat(field);
        }
        return 0.0f;
    }

    public static double parseDouble(String s) {
        String field = VariantFFParser.parseBasicField(s);
        if (field != null) {
            return Double.parseDouble(field);
        }
        return 0.0;
    }

    public static String parseBasicField(String s) {
        if (s.equals("-")) {
            return null;
        }
        return s;
    }

    @Override
    public void close() throws Exception {
        this.bufferedReader.close();
    }

    public static void main(String[] args) throws IOException {
        VariantFFParser variantFFParser = new VariantFFParser(args[0]);
        long count = 0L;
        while (variantFFParser.hasNext()) {
            ++count;
            try {
                variantFFParser.next();
            }
            catch (Exception e) {
                LOGGER.error("Error parsing VariantObject", (Throwable)e);
            }
        }
        LOGGER.info("Total VariantObjects created: {}", (Object)count);
    }
}

