/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.domain.info.impl;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ebi.uniprot.dataservice.domain.info.RawInfoObject;

public class RawInfoObjectImpl
implements RawInfoObject {
    private Map<String, String> infos = new HashMap<String, String>();
    private final String TYPE_KEY_SEPARATOR = "/";

    public RawInfoObjectImpl() {
    }

    public RawInfoObjectImpl(Map<Object, Object> init) {
        init.forEach((key, value) -> this.infos.put(key.toString(), value.toString()));
    }

    Map<String, String> getRawMap() {
        return this.infos;
    }

    @Override
    public void storeInfo(RawInfoObject.InfoType type, RawInfoObject.InfoKey key, String value) {
        String s = this.generateKey(type, key);
        this.infos.put(s, value);
    }

    @Override
    public void storeInfo(RawInfoObject infos) {
        if (!(infos instanceof RawInfoObjectImpl)) {
            throw new IllegalArgumentException("the given info object doesn't have the supported type: " + infos.getClass().getName());
        }
        this.infos.putAll(((RawInfoObjectImpl)infos).infos);
    }

    private String generateKey(RawInfoObject.InfoType type, RawInfoObject.InfoKey key) {
        return type.name() + "/" + key.name();
    }

    @Override
    public String getInfo(RawInfoObject.InfoType type, RawInfoObject.InfoKey key) {
        String s = this.generateKey(type, key);
        return this.infos.get(s);
    }

    @Override
    public Map<RawInfoObject.InfoKey, String> getInfosOfType(RawInfoObject.InfoType type) {
        HashMap<RawInfoObject.InfoKey, String> map = new HashMap<RawInfoObject.InfoKey, String>();
        this.infos.forEach((key, value) -> {
            String[] split = key.split("/");
            if (split[0].equals(type.name())) {
                map.put(RawInfoObject.InfoKey.valueOf(split[1]), (String)value);
            }
        });
        return map;
    }

    @Override
    public String show() {
        StringWriter sw = new StringWriter();
        this.infos.forEach((key, value) -> sw.write(key + "=" + value + "\n"));
        return sw.toString();
    }
}

