/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.uniref.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefDatabaseType;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntry;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntryName;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniRefRepresentativeMember;
import uk.ac.ebi.uniprot.dataservice.client.QueryResult;
import uk.ac.ebi.uniprot.dataservice.client.Response;
import uk.ac.ebi.uniprot.dataservice.client.exception.ServiceException;
import uk.ac.ebi.uniprot.dataservice.client.impl.BasicService;
import uk.ac.ebi.uniprot.dataservice.client.impl.HttpRequestConfig;
import uk.ac.ebi.uniprot.dataservice.client.impl.RequestResponseFactory;
import uk.ac.ebi.uniprot.dataservice.client.uniref.UniRefComponent;
import uk.ac.ebi.uniprot.dataservice.client.uniref.UniRefField;
import uk.ac.ebi.uniprot.dataservice.client.uniref.UniRefQueryBuilder;
import uk.ac.ebi.uniprot.dataservice.client.uniref.UniRefService;
import uk.ac.ebi.uniprot.dataservice.client.uniref.impl.DefaultUniRefRequest;
import uk.ac.ebi.uniprot.dataservice.client.uniref.impl.ResponseAdaptors;
import uk.ac.ebi.uniprot.dataservice.client.uniref.impl.UniRefEntryAdaptor;
import uk.ac.ebi.uniprot.dataservice.document.uniref.UniRefDocument;
import uk.ac.ebi.uniprot.dataservice.query.Query;

class UniRefServiceImpl
implements UniRefService {
    public static final String NAME_REMOTE_SERVER_URL = "UNIREF_REMOTE_SERVER_URL";
    private static final int DEFAULT_PAGE_SIZE = 100;
    private static final Logger logger = LoggerFactory.getLogger(UniRefServiceImpl.class);
    private final RequestResponseFactory factory;
    private final BasicService<Response<UniRefDocument>> service;

    @Inject
    public UniRefServiceImpl(RequestResponseFactory factory, @Named(value="UNIREF_REMOTE_SERVER_URL") String serverURL, HttpRequestConfig serverConfig) {
        this.factory = factory;
        this.service = factory.createServiceForResponseType(serverURL, serverConfig, UniRefDocument.class);
    }

    @Override
    public QueryResult<UniRefEntry> getEntries(Query request) throws ServiceException {
        DefaultUniRefRequest uniRefRequest = new DefaultUniRefRequest(this.factory.createRequest());
        uniRefRequest.setQuery(request);
        uniRefRequest.setResultCardinality(100);
        Response<UniRefDocument> execute = this.service.execute(uniRefRequest);
        return this.factory.createQueryResult(this.service, uniRefRequest, execute, UniRefEntryAdaptor.getInstance());
    }

    @Override
    public QueryResult<UniRefEntry> getEntries(Query request, int offset, int pagesize) throws ServiceException {
        if (pagesize == -1) {
            return this.getEntries(request);
        }
        DefaultUniRefRequest uniRefRequest = new DefaultUniRefRequest(this.factory.createRequest());
        uniRefRequest.setQuery(request);
        if (pagesize < 10000) {
            uniRefRequest.setCursorMark(null);
        }
        uniRefRequest.setResultCardinality(pagesize);
        uniRefRequest.setResultOffset(offset);
        uniRefRequest.setSort(UniRefField.Search.cluster_id, false);
        Response<UniRefDocument> execute = this.service.execute(uniRefRequest);
        return this.factory.createQueryResult(this.service, uniRefRequest, execute, UniRefEntryAdaptor.getInstance());
    }

    @Override
    public UniRefEntry getEntry(String id) throws ServiceException {
        Query query = UniRefQueryBuilder.clusterId(id);
        DefaultUniRefRequest uniRefRequest = new DefaultUniRefRequest(this.factory.createRequest());
        uniRefRequest.setQuery(query);
        uniRefRequest.setResultCardinality(1);
        Response<UniRefDocument> execute = this.service.execute(uniRefRequest);
        List<UniRefDocument> results = execute.getResults();
        if (results.size() > 0) {
            UniRefDocument uniRefDocument = results.get(0);
            return UniRefEntryAdaptor.getInstance().adapt(uniRefDocument);
        }
        return null;
    }

    @Override
    public UniRefEntry getEntryByUniProtAccession(String accession, UniRefDatabaseType database) throws ServiceException {
        DefaultUniRefRequest uniRefRequest = new DefaultUniRefRequest(this.factory.createRequest());
        uniRefRequest.setQuery(this.buildAccessionAndClusterQuery(accession, database));
        uniRefRequest.setResultCardinality(1);
        Response<UniRefDocument> execute = this.service.execute(uniRefRequest);
        List<UniRefDocument> results = execute.getResults();
        if (results.size() > 0) {
            UniRefDocument uniRefDocument = results.get(0);
            return UniRefEntryAdaptor.getInstance().adapt(uniRefDocument);
        }
        return null;
    }

    @Override
    public UniRefEntry getEntryByUniParcUPI(String upi, UniRefDatabaseType database) throws ServiceException {
        DefaultUniRefRequest uniRefRequest = new DefaultUniRefRequest(this.factory.createRequest());
        uniRefRequest.setQuery(this.buildAccessionAndClusterQuery(upi, database));
        uniRefRequest.setResultCardinality(1);
        Response<UniRefDocument> execute = this.service.execute(uniRefRequest);
        List<UniRefDocument> results = execute.getResults();
        if (results.size() > 0) {
            UniRefDocument uniRefDocument = results.get(0);
            return UniRefEntryAdaptor.getInstance().adapt(uniRefDocument);
        }
        return null;
    }

    private Query buildAccessionAndClusterQuery(String accession, UniRefDatabaseType database) {
        Query accessionQuery = UniRefQueryBuilder.representativeAccession(accession);
        Query uniRefDbClusterQuery = UniRefQueryBuilder.uniRefClusterDatabase(database);
        return UniRefQueryBuilder.and(accessionQuery, uniRefDbClusterQuery);
    }

    @Override
    public QueryResult<UniRefComponent<UniRefEntryName>> getUniRefEntryName(Query query) throws ServiceException {
        DefaultUniRefRequest request = new DefaultUniRefRequest(this.factory.createRequest());
        request.setQuery(query);
        request.setFields(UniRefField.Return.cluster_id, UniRefField.Return.cluster_name);
        request.setResultCardinality(100);
        Response<UniRefDocument> execute = this.service.execute(request);
        return this.factory.createQueryResult(this.service, request, execute, ResponseAdaptors.UNIREF_ENTRY_NAME_RESPONSE_ADAPTOR);
    }

    @Override
    public QueryResult<UniRefComponent<UniRefRepresentativeMember>> getUniRefRepresentative(Query query) throws ServiceException {
        DefaultUniRefRequest request = new DefaultUniRefRequest(this.factory.createRequest());
        request.setQuery(query);
        request.setFields(UniRefField.Return.cluster_id, UniRefField.Return.avro_binary);
        request.setResultCardinality(100);
        Response<UniRefDocument> execute = this.service.execute(request);
        return this.factory.createQueryResult(this.service, request, execute, ResponseAdaptors.UNIREF_REPRESENTATIVE_RESPONSE_ADAPTOR);
    }

    @Override
    public boolean isStarted() {
        return this.service.isStarted();
    }

    @Override
    public void start() {
        this.service.start();
    }

    @Override
    public void stop() {
        this.service.stop();
    }
}

