/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.uniparc.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.common.Sequence;
import uk.ac.ebi.kraken.interfaces.uniparc.UniParcEntry;
import uk.ac.ebi.uniprot.dataservice.client.QueryResult;
import uk.ac.ebi.uniprot.dataservice.client.Response;
import uk.ac.ebi.uniprot.dataservice.client.basic.impl.JapiBasicService;
import uk.ac.ebi.uniprot.dataservice.client.exception.ServiceException;
import uk.ac.ebi.uniprot.dataservice.client.impl.BasicService;
import uk.ac.ebi.uniprot.dataservice.client.impl.DefaultQueryResultImpl;
import uk.ac.ebi.uniprot.dataservice.client.impl.DefaultRequestImpl;
import uk.ac.ebi.uniprot.dataservice.client.impl.HttpRequestConfig;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.UniParcComponent;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.UniParcField;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.UniParcQueryBuilder;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.UniParcService;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.impl.DefaultUniParcRequest;
import uk.ac.ebi.uniprot.dataservice.client.uniparc.impl.JapiUniParcResponseAdapter;
import uk.ac.ebi.uniprot.dataservice.query.Query;
import uk.ac.ebi.uniprot.services.data.serializer.model.uniparc.AvroUniParc;

class JapiUniParcServiceImpl
implements UniParcService {
    public static final String NAME_REMOTE_SERVER_URL = "UNIPARC_REMOTE_SERVER_URL";
    private static final int DEFAULT_PAGE_SIZE = 100;
    private final BasicService<Response<AvroUniParc>> service;

    @Inject
    public JapiUniParcServiceImpl(@Named(value="UNIPARC_REMOTE_SERVER_URL") String serverURL, HttpRequestConfig serverConfig) {
        this.service = new JapiBasicService<AvroUniParc>(serverURL, serverConfig, AvroUniParc.class);
    }

    @Override
    public QueryResult<UniParcEntry> getEntries(Query query) throws ServiceException {
        DefaultUniParcRequest request = new DefaultUniParcRequest(new DefaultRequestImpl());
        request.setQuery(query);
        request.setResultCardinality(100);
        Response<AvroUniParc> execute = this.service.execute(request);
        return new DefaultQueryResultImpl<UniParcEntry, AvroUniParc>(this.service, request, execute, JapiUniParcResponseAdapter.entryAdapter);
    }

    @Override
    public QueryResult<UniParcEntry> getEntries(Query query, int offset, int pagesize) throws ServiceException {
        if (pagesize == -1) {
            return this.getEntries(query);
        }
        DefaultUniParcRequest request = new DefaultUniParcRequest(new DefaultRequestImpl());
        request.setQuery(query);
        if (pagesize < 10000) {
            request.setCursorMark(null);
        }
        request.setResultCardinality(pagesize);
        request.setResultOffset(offset);
        Response<AvroUniParc> execute = this.service.execute(request);
        return new DefaultQueryResultImpl<UniParcEntry, AvroUniParc>(this.service, request, execute, JapiUniParcResponseAdapter.entryAdapter);
    }

    @Override
    public UniParcEntry getEntry(String id) throws ServiceException {
        Query query = UniParcQueryBuilder.id(id);
        DefaultUniParcRequest request = new DefaultUniParcRequest(new DefaultRequestImpl());
        request.setQuery(query);
        request.setResultCardinality(1);
        Response<AvroUniParc> execute = this.service.execute(request);
        List<AvroUniParc> results = execute.getResults();
        if (results != null && results.size() > 0) {
            return JapiUniParcResponseAdapter.entryAdapter.adapt(results.get(0));
        }
        return null;
    }

    @Override
    public UniParcEntry getEntryFromUniProtAccession(String accession) throws ServiceException {
        Query query = UniParcQueryBuilder.uniProtAccession(accession);
        DefaultUniParcRequest request = new DefaultUniParcRequest(new DefaultRequestImpl());
        request.setQuery(query);
        request.setResultCardinality(1);
        Response<AvroUniParc> execute = this.service.execute(request);
        List<AvroUniParc> results = execute.getResults();
        if (results != null && results.size() > 0) {
            return JapiUniParcResponseAdapter.entryAdapter.adapt(results.get(0));
        }
        return null;
    }

    @Override
    public QueryResult<UniParcComponent<Sequence>> getSequences(Query query) throws ServiceException {
        DefaultUniParcRequest request = new DefaultUniParcRequest(new DefaultRequestImpl());
        request.setQuery(query);
        request.setFields(UniParcField.Return.upi, UniParcField.Return.avro_binary);
        request.setResultCardinality(100);
        Response<AvroUniParc> execute = this.service.execute(request);
        return new DefaultQueryResultImpl<UniParcComponent<Sequence>, AvroUniParc>(this.service, request, execute, JapiUniParcResponseAdapter.sequenceAdapter);
    }

    @Override
    public boolean isStarted() {
        return this.service.isStarted();
    }

    @Override
    public void start() {
        this.service.start();
    }

    @Override
    public void stop() {
        this.service.stop();
    }
}

