/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.info.impl;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Optional;
import uk.ac.ebi.uniprot.dataservice.client.info.InfoService;
import uk.ac.ebi.uniprot.dataservice.domain.info.InfoObjectConverter;
import uk.ac.ebi.uniprot.dataservice.domain.info.RawInfoObject;
import uk.ac.ebi.uniprot.dataservice.domain.info.RawInfoObjectReader;
import uk.ac.ebi.uniprot.dataservice.domain.info.ServiceInfoObject;

public class InfoServiceImpl
implements InfoService {
    private final InfoObjectConverter converter;
    private final RawInfoObjectReader reader;

    @Inject
    public InfoServiceImpl(InfoObjectConverter converter, @Named(value="JAPI") RawInfoObjectReader reader) {
        this.converter = converter;
        this.reader = reader;
    }

    @Override
    public Optional<ServiceInfoObject> getServiceInfo() {
        Optional<RawInfoObject> read = this.reader.read();
        if (read.isPresent()) {
            RawInfoObject rawInfoObject = read.get();
            ServiceInfoObject convert = this.converter.convert(rawInfoObject);
            return Optional.of(convert);
        }
        return Optional.empty();
    }
}

