/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.info.impl;

import com.google.common.base.Strings;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import uk.ac.ebi.uniprot.dataservice.client.info.InfoService;
import uk.ac.ebi.uniprot.dataservice.client.info.impl.InfoServiceImpl;
import uk.ac.ebi.uniprot.dataservice.client.info.impl.UrlRawInfoObjectReader;
import uk.ac.ebi.uniprot.dataservice.domain.info.InfoObjectConverter;
import uk.ac.ebi.uniprot.dataservice.domain.info.RawInfoObjectReader;
import uk.ac.ebi.uniprot.dataservice.domain.info.impl.InfoObjectConverterImpl;

public class InfoServiceGuiceModule
extends AbstractModule {
    private final String serviceUrl;
    private final String defaultURL = "https://www.ebi.ac.uk/proteins/api/info";

    @Inject
    public InfoServiceGuiceModule(String serviceUrl) {
        this.serviceUrl = Strings.isNullOrEmpty((String)serviceUrl) ? "https://www.ebi.ac.uk/proteins/api/info" : serviceUrl;
    }

    protected void configure() {
        this.bind(InfoService.class).to(InfoServiceImpl.class);
        this.bind(InfoObjectConverter.class).to(InfoObjectConverterImpl.class).in(Singleton.class);
        this.bind(RawInfoObjectReader.class).annotatedWith((Annotation)Names.named((String)"JAPI")).to(UrlRawInfoObjectReader.class);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"InfoServiceRestUrl")).to(this.serviceUrl);
    }
}

