/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.impl;

public enum SolrCollection {
    UNIPROT("UniProtDocument", "uniprot", "accession"),
    UNIPARC("UniParcDocument", "uniparc", "upid"),
    UNIREF("UniRefDocument", "uniref", "cluster_id"),
    ANTIGEN("AntigenDocument", "antigen", "id"),
    COORDINATE("GnCoordinateDocument", "coordinate", "accession"),
    PROTEOME("ProteomeDocument", "proteome", "upid"),
    PROTEOMICS("ProteomicsDocument", "proteomics", "id"),
    VARIATION("VariationDocument", "variation", "id");

    private String responseClassName;
    private String collectionName;
    private String collectionIdFieldName;

    private SolrCollection(String responseClassName, String collectionName, String collectionIdFildName) {
        this.responseClassName = responseClassName;
        this.collectionName = collectionName;
        this.collectionIdFieldName = collectionIdFildName;
    }

    public static SolrCollection getSorCollectionFromResponseClassName(String responseClassName) {
        for (SolrCollection collection : SolrCollection.values()) {
            if (!collection.responseClassName.equals(responseClassName)) continue;
            return collection;
        }
        return null;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getCollectionIdFieldName() {
        return this.collectionIdFieldName;
    }

    public void setCollectionIdFieldName(String collectionIdFieldName) {
        this.collectionIdFieldName = collectionIdFieldName;
    }
}

