/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.beans.DocumentObjectBinder;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import uk.ac.ebi.uniprot.dataservice.client.Response;

public class DefaultResponseImpl<T>
implements Response<T> {
    private final DocumentObjectBinder binder;
    private final QueryResponse response;
    private final Class<T> clazz;

    public DefaultResponseImpl(QueryResponse response, Class<T> clazz) {
        this.response = response;
        this.clazz = clazz;
        this.binder = new DocumentObjectBinder();
    }

    @Override
    public long getHitCount() {
        return this.response.getResults().getNumFound();
    }

    @Override
    public int getResultPageSize() {
        SolrDocumentList results = this.response.getResults();
        return results.size();
    }

    @Override
    public long getResultSetStart() {
        return this.response.getResults().getStart();
    }

    @Override
    public List<T> getResults() {
        SolrDocumentList results = this.response.getResults();
        ArrayList<Object> documents = new ArrayList<Object>();
        for (SolrDocument solr : results) {
            documents.add(this.binder.getBean(this.clazz, solr));
        }
        return documents;
    }

    @Override
    public String getCursorMark() {
        return this.response.getNextCursorMark();
    }
}

