/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl;

import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.BlastInput;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.InternalBlastException;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.JobDispatcher;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.JobStatus;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.DatabaseOption;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.FilterOption;
import uk.ac.ebi.uniprot.dataservices.jaxb.blast.EBIApplicationResult;
import uk.ac.ebi.uniprot.dataservices.jaxb.rest.ErrorException;
import uk.ac.ebi.uniprot.dataservices.jaxb.rest.WwwEbiAcUk_ToolsServicesRestNcbiblast;

@Singleton
class XmlRestJobDispatcher
implements JobDispatcher<BlastInput, EBIApplicationResult> {
    private static final String JOB_SUBMISSION_EMAIL = "udw_prod@ebi.ac.uk";
    private static final String JOB_TITTLE = "UJDK";
    private static final String RESULT_TYPE = "xml";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    XmlRestJobDispatcher() {
    }

    @Override
    public JobStatus checkStatus(String jobId) {
        if (jobId == null) {
            throw new InternalBlastException("Job id can not be null");
        }
        try {
            String statusText = WwwEbiAcUk_ToolsServicesRestNcbiblast.statusJobId(jobId).getAsTextPlain(String.class);
            return JobStatus.typeOf(statusText);
        }
        catch (ErrorException e) {
            throw new InternalBlastException("Error checking job status with jobId: " + jobId, (Throwable)((Object)e));
        }
    }

    @Override
    public String submit(BlastInput input) {
        if (input == null) {
            throw new InternalBlastException("Blast input is null");
        }
        try {
            MultivaluedMap<String, String> inputMap = this.convertInputToWebServiceValues(input);
            return WwwEbiAcUk_ToolsServicesRestNcbiblast.run().postXWwwFormUrlencodedAsTextPlain(inputMap, String.class);
        }
        catch (ErrorException e) {
            throw new InternalBlastException("Error submitting job with input: " + input.toString(), (Throwable)((Object)e));
        }
    }

    @Override
    public EBIApplicationResult getResult(String jobId) {
        EBIApplicationResult rawBlastResult;
        if (jobId == null) {
            throw new InternalBlastException("Unable to retrieve result for null jobId");
        }
        try {
            rawBlastResult = WwwEbiAcUk_ToolsServicesRestNcbiblast.resultJobIdType(jobId, RESULT_TYPE).getAsOctetStream(EBIApplicationResult.class);
        }
        catch (ErrorException e) {
            this.logger.error("Error retrieving blast data from EBI server for job: {}", (Object)jobId, (Object)e);
            throw new InternalBlastException("Unable to retrieve blast results");
        }
        return rawBlastResult;
    }

    private MultivaluedMap<String, String> convertInputToWebServiceValues(BlastInput input) {
        String seqRange;
        MultivaluedHashMap inputMap = new MultivaluedHashMap();
        inputMap.add((Object)BlastParameter.EMAIL.getName(), (Object)JOB_SUBMISSION_EMAIL);
        inputMap.add((Object)BlastParameter.TITLE.getName(), (Object)JOB_TITTLE);
        inputMap.add((Object)BlastParameter.SEQUENCE.getName(), (Object)input.getSequence());
        inputMap.add((Object)BlastParameter.PROGRAM.getName(), (Object)input.getBlastVersion().getVersion());
        inputMap.add((Object)BlastParameter.STYPE.getName(), (Object)input.getSequenceType().getType());
        inputMap.add((Object)BlastParameter.MATRIX.getName(), (Object)input.getMatrix().getMatrix());
        inputMap.add((Object)BlastParameter.ALIGNMENTS.getName(), (Object)input.getAlignmentCutoff().getCutoff());
        inputMap.add((Object)BlastParameter.SCORES.getName(), (Object)input.getScoreCutoff().getCutoff());
        inputMap.add((Object)BlastParameter.EXP.getName(), (Object)input.getExpectation().getExpectationValue());
        inputMap.add((Object)BlastParameter.DROPOFF.getName(), (Object)input.getDropOff().getValue());
        inputMap.add((Object)BlastParameter.GAPALIGN.getName(), (Object)String.valueOf(input.hasGapAlign()));
        inputMap.add((Object)BlastParameter.GAPOPEN.getName(), (Object)String.valueOf(input.getGapOpen()));
        inputMap.add((Object)BlastParameter.GAPEXT.getName(), (Object)String.valueOf(input.getGapExt()));
        FilterOption filter = input.getFilter();
        if (filter != null) {
            inputMap.add((Object)BlastParameter.FILTER.getName(), (Object)filter.getFilter());
        }
        if ((seqRange = input.getSeqRange()) != null) {
            inputMap.add((Object)BlastParameter.SEQRANGE.getName(), (Object)seqRange);
        }
        inputMap.addAll((Object)BlastParameter.DATABASE.getName(), input.getBlastDatabases().stream().map(DatabaseOption::getDbName).collect(Collectors.toList()));
        return inputMap;
    }

    private static enum BlastParameter {
        EMAIL("email"),
        TITLE("title"),
        PROGRAM("program"),
        MATRIX("matrix"),
        ALIGNMENTS("alignments"),
        SCORES("scores"),
        EXP("exp"),
        DROPOFF("dropoff"),
        MATCH_SCORES("match_scores"),
        GAPOPEN("gapopen"),
        GAPEXT("gapext"),
        FILTER("filter"),
        SEQRANGE("seqrange"),
        GAPALIGN("gapalign"),
        COMPSTATS("compstats"),
        ALIGN("align"),
        TRANSLTABLE("transltable"),
        STYPE("stype"),
        SEQUENCE("sequence"),
        DATABASE("database");

        private final String name;

        private BlastParameter(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

