/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl;

import com.google.inject.Singleton;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.BlastInput;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.BlastResult;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniProtBlastService;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniProtBlastSummary;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.UniProtHit;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.AbstractBlastService;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.BlastAnnotations;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.BlastResultImpl;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.DispatcherSubmissionService;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.LazyUniProtHit;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.impl.SummaryConverter;
import uk.ac.ebi.uniprot.dataservice.client.alignment.blast.input.DatabaseOption;
import uk.ac.ebi.uniprot.dataservice.client.uniprot.UniProtService;
import uk.ac.ebi.uniprot.dataservices.jaxb.blast.EBIApplicationResult;
import uk.ac.ebi.uniprot.dataservices.jaxb.blast.THit;
import uk.ac.ebi.uniprot.dataservices.jaxb.blast.THits;

@Singleton
class UniProtBlastServiceImpl
extends AbstractBlastService<UniProtHit, EBIApplicationResult>
implements UniProtBlastService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final UniProtService searchService;
    private final SummaryConverter<THit, UniProtBlastSummary> converter;
    boolean isStarted;

    @Inject
    public UniProtBlastServiceImpl(DispatcherSubmissionService<BlastInput, EBIApplicationResult> submissionService, @BlastAnnotations.UniProtSummaryConverter SummaryConverter<THit, UniProtBlastSummary> converter, UniProtService searchService) {
        super(submissionService);
        this.searchService = searchService;
        this.converter = converter;
        this.isStarted = false;
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public void start() {
        if (!this.isStarted()) {
            this.searchService.start();
            this.isStarted = true;
        }
    }

    @Override
    public void stop() {
        if (this.isStarted()) {
            this.searchService.stop();
            this.isStarted = false;
        }
    }

    @Override
    protected BlastResult<UniProtHit> buildBlastResult(EBIApplicationResult ebiResult, BlastInput input) {
        THits rawHits = ebiResult.getSequenceSimilaritySearchResult().getHits();
        BlastResultImpl<UniProtHit> blastResult = new BlastResultImpl<UniProtHit>();
        for (THit rawHit : rawHits.getHit()) {
            try {
                UniProtBlastSummary summary = this.converter.convert(rawHit);
                blastResult.addHit(new LazyUniProtHit(summary, this.searchService));
            }
            catch (IllegalArgumentException e) {
                this.logger.warn("Unable to process the following raw hit: {} for job with input: {}", (Object)rawHit, (Object)input);
            }
        }
        return blastResult;
    }

    @Override
    protected void checkBlastInput(BlastInput input) {
        if (input == null) {
            throw new IllegalArgumentException("Blast input can not be null");
        }
        input.getBlastDatabases().forEach(this::checkDatabase);
    }

    private void checkDatabase(DatabaseOption database) {
        switch (database) {
            case SWISSPROT: 
            case TREMBL: 
            case UNIPROTKB: 
            case UNIPROT_ARCHAEA: 
            case UNIPROT_ARTHROPODA: 
            case UNIPROT_BACTERIA: 
            case UNIPROT_COMPLETE_MICROBIAL_PROTEOMES: 
            case UNIPROT_EUKARYOTA: 
            case UNIPROT_FUNGI: 
            case UNIPROT_HUMAN: 
            case UNIPROT_MAMMALS: 
            case UNIPROT_NEMATODA: 
            case UNIPROT_PDB: 
            case UNIPROT_RODENTS: 
            case UNIPROT_VERTEBRATES: 
            case UNIPROT_VIRIDIPLANTAE: 
            case UNIPROT_VIRUSES: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Provided database option can not be processed by the UniProt blast service");
            }
        }
    }
}

