/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.uniprot.dataservice.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Base64;
import java.util.Optional;
import uk.ac.ebi.uniprot.dataservice.client.Request;

public class RequestSerializer {
    static final String ENUM_PREFIX = "uk.ac.ebi.uniprot.dataservice.";

    public static Optional<Request> base64ToRequest(String base64String, Class<? extends Request> requestClass) {
        Optional<Request> result = Optional.empty();
        try {
            String jsonString = new String(Base64.getDecoder().decode(base64String.getBytes()));
            Request jacksonRequest = (Request)RequestSerializer.getObjectMapper().readValue(jsonString, requestClass);
            result = Optional.of(jacksonRequest);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Optional<String> requestToBase64(Request request) {
        Optional<String> result = Optional.empty();
        try {
            String jsonString = RequestSerializer.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)request);
            result = Optional.of(Base64.getEncoder().encodeToString(jsonString.getBytes()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static ObjectMapper getObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Enum.class, (JsonDeserializer)new EnumDeserializer());
        module.addSerializer(Enum.class, (JsonSerializer)new EnumSerializer());
        mapper.registerModule((Module)module);
        return mapper;
    }

    static class EnumSerializer
    extends StdSerializer<Enum> {
        EnumSerializer() {
            this(null);
        }

        EnumSerializer(Class<Enum> t) {
            super(t);
        }

        public void serialize(Enum eEnum, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            String className = eEnum.getClass().getName().substring(RequestSerializer.ENUM_PREFIX.length());
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("type", className);
            jsonGenerator.writeStringField("value", eEnum.name());
            jsonGenerator.writeEndObject();
        }
    }

    static class EnumDeserializer
    extends StdDeserializer<Enum> {
        EnumDeserializer() {
            this(null);
        }

        EnumDeserializer(Class<?> vc) {
            super(vc);
        }

        public Enum deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            try {
                Class<?> enumClass = Class.forName(RequestSerializer.ENUM_PREFIX + node.get("type").asText());
                Object enumObject = Enum.valueOf(enumClass, node.get("value").asText());
                return enumObject;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

