/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.xdb;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.go.GoEvidenceConverter;
import uk.ac.ebi.kraken.interfaces.uniprot.dbx.go.GoEvidenceType;

public enum GoEvidenceConverterUtil implements GoEvidenceConverter
{
    INSTANCE;

    private static final String COLON = ":";
    private static final String DEFAULT = "Default";
    private Map<String, String> defaultMapping = new HashMap<String, String>();
    private Map<String, String> defaultMappingFromEco = new HashMap<String, String>();
    private Map<String, String> otherMapping = new HashMap<String, String>();
    private final String filepath = "https://raw.githubusercontent.com/evidenceontology/evidenceontology/master/gaf-eco-mapping.txt";
    private final String localfilepath = "conf/gaf-eco-mapping.txt";

    private GoEvidenceConverterUtil() {
        this.init();
    }

    @Override
    public String convertToECOCode(GoEvidenceType evidenceType) {
        return this.defaultMapping.get(evidenceType.getValue());
    }

    @Override
    public String convertToECOCode(GoEvidenceType evidenceType, String goRef) {
        if (goRef == null || goRef.isEmpty() || DEFAULT.equalsIgnoreCase(goRef)) {
            return this.defaultMapping.get(evidenceType.getValue());
        }
        String ecoCode = this.otherMapping.get(evidenceType.getValue() + COLON + goRef);
        if (ecoCode != null) {
            return ecoCode;
        }
        return this.defaultMapping.get(evidenceType.getValue());
    }

    @Override
    public GoEvidenceType convertFromECOCode(String ecoCode) {
        String val = this.defaultMappingFromEco.get(ecoCode);
        if (val == null) {
            for (Map.Entry<String, String> entry : this.otherMapping.entrySet()) {
                if (!entry.getValue().equals(ecoCode)) continue;
                val = entry.getKey().substring(0, entry.getKey().indexOf(COLON));
            }
        }
        if (val == null) {
            return GoEvidenceType.UNKNOWN;
        }
        return GoEvidenceType.parseGoEvidenceType(val);
    }

    private void init() {
        try {
            String l;
            InputStream is = this.getInputStreamFromURL();
            if (is == null) {
                is = this.getClass().getClassLoader().getResourceAsStream("conf/gaf-eco-mapping.txt");
            }
            if (is == null) {
                return;
            }
            BufferedReader bif = new BufferedReader(new InputStreamReader(is));
            while ((l = bif.readLine()) != null) {
                if ((l = l.trim()).length() == 0 || l.startsWith("#")) continue;
                this.parseLine(l);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private InputStream getInputStreamFromURL() {
        try {
            URL url = new URL("https://raw.githubusercontent.com/evidenceontology/evidenceontology/master/gaf-eco-mapping.txt");
            return url.openStream();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void parseLine(String line) {
        String[] tokens = line.split("\t");
        if (tokens.length < 3) {
            return;
        }
        if (tokens[1].equalsIgnoreCase(DEFAULT)) {
            this.defaultMapping.put(tokens[0], tokens[2]);
            this.defaultMappingFromEco.put(tokens[2], tokens[0]);
        } else {
            String val = tokens[0] + COLON + tokens[1];
            this.otherMapping.put(val, tokens[2]);
        }
    }
}

