/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniref;

import java.math.BigInteger;
import uk.ac.ebi.kraken.interfaces.common.MoleculeWeight;
import uk.ac.ebi.kraken.interfaces.common.Sequence;
import uk.ac.ebi.kraken.interfaces.factories.UniRefFactory;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniRefRepresentativeMember;
import uk.ac.ebi.kraken.model.factories.DefaultUniRefFactory;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniref.MemberType;
import uk.ac.ebi.kraken.xml.uniref.AbstractUniRefMemberHandler;

public class UniRefRepresentativeMemberHandler
extends AbstractUniRefMemberHandler<UniRefRepresentativeMember>
implements GenericHandler<UniRefRepresentativeMember, MemberType> {
    private final UniRefFactory krakenFactory = DefaultUniRefFactory.getInstance();

    @Override
    public UniRefRepresentativeMember fromXmlBinding(MemberType member) {
        UniRefRepresentativeMember result = this.krakenFactory.buildUniRefRepresentativeMember();
        this.updateMemberFromXmlBinding(result, member);
        MemberType.Sequence sequence = member.getSequence();
        if (sequence != null) {
            result.setSequence(this.convertSequenceFromXmlBinding(sequence));
        }
        return result;
    }

    private Sequence convertSequenceFromXmlBinding(MemberType.Sequence sequence) {
        Sequence resultSequence = this.krakenFactory.buildSequence();
        String seqString = sequence.getValue();
        StringBuilder realSequence = new StringBuilder();
        for (int iii = 0; iii < seqString.length(); ++iii) {
            char c = seqString.charAt(iii);
            if (c == '\t' || c == '\n' || c == ' ') continue;
            realSequence.append(c);
        }
        resultSequence.setValue(realSequence.toString());
        resultSequence.setCRC64(sequence.getChecksum());
        resultSequence.setMolecularWeight(MoleculeWeight.calcMolecularWeight(realSequence.toString()));
        return resultSequence;
    }

    private MemberType.Sequence convertToXmlBinding(Sequence sequence) {
        MemberType.Sequence result = this.jaxbFactory.createMemberTypeSequence();
        String rawSequence = sequence.getValue();
        StringBuilder sequenceBuffer = new StringBuilder();
        for (int iii = 0; iii < rawSequence.length(); ++iii) {
            if (iii % 60 == 0) {
                sequenceBuffer.append("\n                ");
            }
            sequenceBuffer.append(rawSequence.charAt(iii));
        }
        sequenceBuffer.append("\n            ");
        result.setValue(sequenceBuffer.toString());
        result.setChecksum(sequence.getCRC64());
        result.setLength(BigInteger.valueOf(sequence.getLength()));
        return result;
    }

    @Override
    public MemberType toXmlBinding(UniRefRepresentativeMember object) {
        MemberType member = this.convertToXmlBinding(object);
        member.setSequence(this.convertToXmlBinding(object.getSequence()));
        return member;
    }
}

