/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniref;

import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.interfaces.uniref.UniRefEntry;
import uk.ac.ebi.kraken.xml.uniref.UniRef100Handler;
import uk.ac.ebi.kraken.xml.uniref.UniRef50Handler;
import uk.ac.ebi.kraken.xml.uniref.UniRef90Handler;

public class UniRefEntryJAXBConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UniRefEntryJAXBConverter.class);
    private static UniRefEntryJAXBConverter singletonInstance;
    private final UniRef50Handler uniRef50Handler = new UniRef50Handler();
    private final UniRef90Handler uniRef90Handler = new UniRef90Handler();
    private final UniRef100Handler uniRef100Handler = new UniRef100Handler();

    protected UniRefEntryJAXBConverter() {
    }

    public static synchronized UniRefEntryJAXBConverter getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new UniRefEntryJAXBConverter();
        }
        return singletonInstance;
    }

    public String toXML(UniRefEntry entry) {
        StringWriter resultWriter = new StringWriter();
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"uk.ac.ebi.kraken.xml.jaxb.uniref");
            Marshaller m = jaxbContext.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal(this.convert(entry), (Writer)resultWriter);
        }
        catch (JAXBException e) {
            LOG.error(e.getMessage());
        }
        return resultWriter.toString();
    }

    public String toHTMLForm(UniRefEntry entry) {
        String xml = this.toXML(entry);
        StringBuilder result = new StringBuilder();
        block6: for (int iii = 0; iii < xml.length(); ++iii) {
            char c = xml.charAt(iii);
            switch (c) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&#034;");
                    continue block6;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    private Object convert(UniRefEntry entry) throws JAXBException {
        switch (entry.getUniRefDatabase().getType()) {
            case UniRef100: {
                return this.uniRef100Handler.toXmlBinding(entry);
            }
            case UniRef50: {
                return this.uniRef50Handler.toXmlBinding(entry);
            }
            case UniRef90: {
                return this.uniRef90Handler.toXmlBinding(entry);
            }
        }
        throw new IllegalArgumentException("The UniRef entry's database is currently undefined");
    }

    public void writeEntry(UniRefEntry entry, OutputStream out) throws JAXBException {
        Object jaxbUniRef = this.convert(entry);
        JAXBContext jaxbContext = JAXBContext.newInstance((String)"uk.ac.ebi.kraken.xml.jaxb.uniref");
        Marshaller m = jaxbContext.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.marshal(jaxbUniRef, out);
    }
}

