/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniref;

import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.UniRefFactory;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniProtAccession;
import uk.ac.ebi.kraken.interfaces.uniref.member.UniRefMember;
import uk.ac.ebi.kraken.model.factories.DefaultUniRefFactory;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniref.DbReferenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniref.MemberType;
import uk.ac.ebi.kraken.xml.jaxb.uniref.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniref.PropertyType;

public abstract class AbstractUniRefMemberHandler<T extends UniRefMember>
implements GenericHandler<T, MemberType> {
    public static final String PROPERTY_PROTEIN_NAME = "protein name";
    public static final String PROPERTY_NCBI_TAXONOMY = "NCBI taxonomy";
    public static final String PROPERTY_SOURCE_ORGANISM = "source organism";
    public static final String PROPERTY_SOURCE_UNIPARC = "UniParc ID";
    public static final String PROPERTY_SOURCE_UNIREF100 = "UniRef100 ID";
    public static final String PROPERTY_SOURCE_UNIREF90 = "UniRef90 ID";
    public static final String PROPERTY_SOURCE_UNIREF50 = "UniRef50 ID";
    public static final String PROPERTY_SOURCE_UNIPROT = "UniProtKB accession";
    public static final String PROPERTY_SOURCE_LENGTH = "length";
    public static final String PROPERTY_SOURCE_OVERLAP = "overlap region";
    public static final String PROPERTY_IS_SEED = "isSeed";
    protected final UniRefFactory krakenFactory = DefaultUniRefFactory.getInstance();
    protected final ObjectFactory jaxbFactory = new ObjectFactory();

    protected void updateMemberFromXmlBinding(UniRefMember result, MemberType member) {
        DbReferenceType dbRef = member.getDbReference();
        this.copyPropertiesFromXmlBinding(member, result);
        result.setType(this.krakenFactory.buildMemberType(dbRef.getType()));
        result.setMemberId(this.krakenFactory.buildMemberId(dbRef.getId()));
    }

    protected MemberType convertToXmlBinding(UniRefMember member) {
        MemberType result = this.jaxbFactory.createMemberType();
        DbReferenceType dbRef = this.jaxbFactory.createDbReferenceType();
        dbRef.setId(member.getMemberId().getValue());
        dbRef.setType(member.getType().getValue());
        result.setDbReference(dbRef);
        this.copyPropertiesToXmlBinding(member, result);
        return result;
    }

    private void copyPropertiesFromXmlBinding(MemberType jaxbMember, UniRefMember krakenMember) {
        List<PropertyType> properties = jaxbMember.getDbReference().getProperty();
        for (PropertyType property : properties) {
            if (property.getType().equals(PROPERTY_NCBI_TAXONOMY)) {
                krakenMember.setNCBITaxonomy(this.krakenFactory.buildMemberNCBITaxonomy(property.getValue()));
                continue;
            }
            if (property.getType().equals(PROPERTY_PROTEIN_NAME)) {
                krakenMember.setProteinName(this.krakenFactory.buildMemberProteinName(property.getValue()));
                continue;
            }
            if (property.getType().equals(PROPERTY_SOURCE_ORGANISM)) {
                krakenMember.setSourceOrganism(this.krakenFactory.buildMemberSourceOrganism(property.getValue()));
                continue;
            }
            if (property.getType().equals(PROPERTY_SOURCE_UNIPARC)) {
                krakenMember.setUniParcAccession(this.krakenFactory.buildMemberUniParcAccession(property.getValue()));
                continue;
            }
            if (property.getType().equals(PROPERTY_SOURCE_LENGTH)) {
                krakenMember.setLength(Integer.parseInt(property.getValue()));
                continue;
            }
            if (property.getType().equals(PROPERTY_SOURCE_OVERLAP)) {
                String strOverlap = property.getValue();
                String strStart = strOverlap.substring(0, strOverlap.indexOf(45));
                String strEnd = strOverlap.substring(strOverlap.indexOf(45) + 1, strOverlap.length());
                krakenMember.setOverlapRegion(this.krakenFactory.buildMemberOverlapRegion(Integer.parseInt(strStart), Integer.parseInt(strEnd)));
                continue;
            }
            if (property.getType().equals(PROPERTY_SOURCE_UNIREF100)) {
                krakenMember.setUniRef100EntryId(this.krakenFactory.buildUniRefEntryId(property.getValue()));
                continue;
            }
            if (property.getType().equals(PROPERTY_SOURCE_UNIREF90)) {
                krakenMember.setUniRef90EntryId(this.krakenFactory.buildUniRefEntryId(property.getValue()));
                continue;
            }
            if (property.getType().equals(PROPERTY_SOURCE_UNIREF50)) {
                krakenMember.setUniRef50EntryId(this.krakenFactory.buildUniRefEntryId(property.getValue()));
                continue;
            }
            if (property.getType().equals(PROPERTY_SOURCE_UNIPROT)) {
                krakenMember.getUniProtAccessions().add(this.krakenFactory.buildMemberUniProtAccession(property.getValue()));
                continue;
            }
            if (property.getType().equals(PROPERTY_IS_SEED)) {
                krakenMember.setSeed(Boolean.parseBoolean(property.getValue()));
                continue;
            }
            System.out.println("property.getType() = " + property.getType());
        }
    }

    protected void copyPropertiesToXmlBinding(UniRefMember krakenMember, MemberType jaxbMember) {
        PropertyType property;
        String ncbiTaxonomy = krakenMember.getNCBITaxonomy().getValue();
        String proteinName = krakenMember.getProteinName().getValue();
        String sourceOrganism = krakenMember.getSourceOrganism().getValue();
        String uniparcAccession = krakenMember.getUniParcAccession().getValue();
        String overlap = krakenMember.getOverlapRegion().getStart() + "-" + krakenMember.getOverlapRegion().getEnd();
        int length = krakenMember.getLength();
        String uniRef100 = krakenMember.getUniRef100EntryId().getValue();
        String uniRef90 = krakenMember.getUniRef90EntryId().getValue();
        String uniRef50 = krakenMember.getUniRef50EntryId().getValue();
        if (!uniRef100.equals("")) {
            property = this.jaxbFactory.createPropertyType();
            property.setType(PROPERTY_SOURCE_UNIREF100);
            property.setValue(uniRef100);
            jaxbMember.getDbReference().getProperty().add(property);
        }
        if (!uniRef90.equals("")) {
            property = this.jaxbFactory.createPropertyType();
            property.setType(PROPERTY_SOURCE_UNIREF90);
            property.setValue(uniRef90);
            jaxbMember.getDbReference().getProperty().add(property);
        }
        if (!uniRef50.equals("")) {
            property = this.jaxbFactory.createPropertyType();
            property.setType(PROPERTY_SOURCE_UNIREF50);
            property.setValue(uniRef50);
            jaxbMember.getDbReference().getProperty().add(property);
        }
        if (!ncbiTaxonomy.equals("")) {
            property = this.jaxbFactory.createPropertyType();
            property.setType(PROPERTY_NCBI_TAXONOMY);
            property.setValue(ncbiTaxonomy);
            jaxbMember.getDbReference().getProperty().add(property);
        }
        if (!proteinName.equals("")) {
            property = this.jaxbFactory.createPropertyType();
            property.setType(PROPERTY_PROTEIN_NAME);
            property.setValue(proteinName);
            jaxbMember.getDbReference().getProperty().add(property);
        }
        if (!sourceOrganism.equals("")) {
            property = this.jaxbFactory.createPropertyType();
            property.setType(PROPERTY_SOURCE_ORGANISM);
            property.setValue(sourceOrganism);
            jaxbMember.getDbReference().getProperty().add(property);
        }
        if (!uniparcAccession.equals("")) {
            property = this.jaxbFactory.createPropertyType();
            property.setType(PROPERTY_SOURCE_UNIPARC);
            property.setValue(uniparcAccession);
            jaxbMember.getDbReference().getProperty().add(property);
        }
        if (!overlap.equals("0-0")) {
            property = this.jaxbFactory.createPropertyType();
            property.setType(PROPERTY_SOURCE_OVERLAP);
            property.setValue(overlap);
            jaxbMember.getDbReference().getProperty().add(property);
        }
        if (length > 0) {
            property = this.jaxbFactory.createPropertyType();
            property.setType(PROPERTY_SOURCE_LENGTH);
            property.setValue(String.valueOf(length));
            jaxbMember.getDbReference().getProperty().add(property);
        }
        for (UniProtAccession ua : krakenMember.getUniProtAccessions()) {
            String strAc = ua.getValue();
            if (strAc.equals("")) continue;
            PropertyType property2 = this.jaxbFactory.createPropertyType();
            property2.setType(PROPERTY_SOURCE_UNIPROT);
            property2.setValue(strAc);
            jaxbMember.getDbReference().getProperty().add(property2);
        }
    }
}

