/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.organism;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.NcbiTaxon;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.OrganismType;

public class NcbiTaxonHandler
implements GenericHandler<List<NcbiTaxon>, OrganismType.Lineage> {
    private final UniProtFactory uniProtFactory;
    private final ObjectFactory objectFactory;

    public NcbiTaxonHandler(UniProtFactory uniProtFactory, ObjectFactory objectFactory) {
        this.uniProtFactory = uniProtFactory;
        this.objectFactory = objectFactory;
    }

    @Override
    public List<NcbiTaxon> fromXmlBinding(OrganismType.Lineage lineageXML) {
        ArrayList<NcbiTaxon> ncbiTaxons = new ArrayList<NcbiTaxon>();
        if (lineageXML != null) {
            for (String taxon : lineageXML.getTaxon()) {
                ncbiTaxons.add(this.uniProtFactory.buildNcbiTaxon(taxon));
            }
        }
        return ncbiTaxons;
    }

    @Override
    public OrganismType.Lineage toXmlBinding(List<NcbiTaxon> taxonList) {
        OrganismType.Lineage lineageXML = this.objectFactory.createOrganismTypeLineage();
        for (NcbiTaxon ncbiTaxon : taxonList) {
            lineageXML.getTaxon().add(ncbiTaxon.getValue());
        }
        return lineageXML;
    }
}

