/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.main;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.interfaces.keywordlist.KeywordEntry;
import uk.ac.ebi.kraken.model.factories.DefaultKeywordListFactory;
import uk.ac.ebi.kraken.parser.keywordlist.KeywordListParser;
import uk.ac.ebi.kraken.xml.uniprot.KeywordListConverter;
import uk.ac.ebi.kraken.xml.uniprot.main.KeywordXmlConfigure;

public class KeywordXmlBuilderMain {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeywordXmlBuilderMain.class);

    public static void main(String[] args) {
        KeywordXmlConfigure configure = KeywordXmlConfigure.fromCommandLine(args);
        if (!configure.isValid()) {
            System.out.println(configure.getUsage());
            System.exit(1);
        }
        KeywordXmlBuilderMain main = new KeywordXmlBuilderMain();
        try {
            main.processData(configure.getKeywordFile(), configure.getOutputFile());
        }
        catch (IOException e) {
            LOGGER.error("xml build failed", (Throwable)e);
            System.exit(1);
        }
    }

    public void processData(String inputFile, String outputFile) throws IOException {
        try {
            KeywordListConverter converter = new KeywordListConverter(DefaultKeywordListFactory.getInstance());
            Collection<KeywordEntry> keywordEntries = KeywordListParser.parseAll(new File(inputFile));
            converter.writeKeywordList(outputFile, keywordEntries);
        }
        catch (JAXBException e) {
            System.err.println("Keywordlist converter failed");
            throw new IOException("Keywordlist converter failed");
        }
    }
}

