/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryCommentNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryCommentSource;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MassSpectrometryMethod;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.EvidencedStringType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.MoleculeType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.CommentItemFactory;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class MassSpectrometryHandler
implements GenericHandler<MassSpectrometryComment, uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType> {
    private final CommentFactory commentFactory;
    private final ObjectFactory objectFactory;
    private final EvidenceReferenceHandler evidenceReferenceHandler;
    private final GenericHandler<MassSpectrometryCommentNote, String> massSpecNoteHandler;

    public MassSpectrometryHandler(CommentFactory commentFactory, ObjectFactory objectFactory, EvidenceReferenceHandler referenceHandler) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        this.evidenceReferenceHandler = referenceHandler;
        CommentItemFactory itemFactory = new CommentItemFactory();
        itemFactory.setObjectFactory(objectFactory);
        itemFactory.setCommentFactory(commentFactory);
        itemFactory.setEvidenceReferenceHandler(referenceHandler);
        this.massSpecNoteHandler = itemFactory.buildMassSpectrometryNoteHandler();
    }

    @Override
    public MassSpectrometryComment fromXmlBinding(uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType commentXML) {
        MassSpectrometryComment comment = (MassSpectrometryComment)this.commentFactory.buildComment(CommentType.MASS_SPECTROMETRY);
        if (commentXML != null) {
            if (commentXML.getMolecule() != null) {
                comment.setMolecule(commentXML.getMolecule().getValue());
            }
            if (commentXML.getMethod() != null) {
                comment.setMethod(MassSpectrometryMethod.toType(commentXML.getMethod()));
            }
            if (commentXML.getError() != null) {
                comment.setMolWeightError(Float.parseFloat(commentXML.getError()));
            }
            if (commentXML.getMass() != null) {
                comment.setMolWeight(commentXML.getMass().floatValue());
            }
            if (!commentXML.getText().isEmpty()) {
                comment.setNote(this.massSpecNoteHandler.fromXmlBinding(commentXML.getText().get(0).getValue()));
            }
            if (!commentXML.getEvidence().isEmpty()) {
                List<Integer> evidenceList = commentXML.getEvidence();
                ArrayList<MassSpectrometryCommentSource> sourceList = new ArrayList<MassSpectrometryCommentSource>();
                if (evidenceList != null && !evidenceList.isEmpty()) {
                    for (Integer evidence : evidenceList) {
                        EvidenceId evId = this.evidenceReferenceHandler.getEvidenceIdForIndex2(evidence);
                        sourceList.add(this.commentFactory.buildMassSpectrometryCommentSourceFromAttribute(evId.getValue()));
                        comment.getEvidenceIds().add(evId);
                    }
                }
                comment.setSources(sourceList);
            }
            return comment;
        }
        return null;
    }

    @Override
    public uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType toXmlBinding(MassSpectrometryComment comment) {
        uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType commentXML = this.objectFactory.createCommentType();
        if (comment != null) {
            List<Integer> ev;
            if (!Strings.isNullOrEmpty((String)comment.getMolecule())) {
                MoleculeType mol = this.objectFactory.createMoleculeType();
                mol.setValue(comment.getMolecule());
                commentXML.setMolecule(mol);
            }
            if (comment.getMethod() != null) {
                commentXML.setMethod(comment.getMethod().getValue());
            }
            if (comment.getMolWeight() > 0.0f) {
                commentXML.setMass(Float.valueOf(comment.getMolWeight()));
            }
            if (comment.getMolWeightError() > 0.0f) {
                commentXML.setError(Float.toString(comment.getMolWeightError()));
            }
            this.setNoteToXml(comment, commentXML);
            commentXML.setType(CommentType.MASS_SPECTROMETRY.toDisplayName().toLowerCase());
            if (!comment.getEvidenceIds().isEmpty() && !(ev = this.evidenceReferenceHandler.writeEvidenceIDs(comment.getEvidenceIds())).isEmpty()) {
                commentXML.getEvidence().addAll(ev);
            }
            return commentXML;
        }
        return null;
    }

    private void setNoteToXml(MassSpectrometryComment comment, uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType commentXML) {
        if (comment.getNote() != null && !comment.getNote().getValue().trim().isEmpty()) {
            EvidencedStringType noteXML = this.objectFactory.createEvidencedStringType();
            noteXML.setValue(this.massSpecNoteHandler.toXmlBinding(comment.getNote()));
            commentXML.getText().add(noteXML);
        }
    }
}

