/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.comment;

import com.google.common.base.Strings;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.factories.CommentFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CatalyticActivityCommentStructured;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PhysiologicalReaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Reaction;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.MoleculeType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.PhysiologicalReactionType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ReactionType;
import uk.ac.ebi.kraken.xml.uniprot.comment.CommentItemFactory;
import uk.ac.ebi.kraken.xml.uniprot.comment.PhysiologicalReactionHandler;
import uk.ac.ebi.kraken.xml.uniprot.comment.ReactionHandler;
import uk.ac.ebi.kraken.xml.uniprot.evidence.EvidenceReferenceHandler;

public class CatalyticActivityCommentStructuredHandler
implements GenericHandler<CatalyticActivityCommentStructured, uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType> {
    private final CommentFactory commentFactory;
    private final ObjectFactory objectFactory;
    private final GenericHandler<Reaction, ReactionType> reactionHandler;
    private final GenericHandler<PhysiologicalReaction, PhysiologicalReactionType> physicReactionHandler;

    public CatalyticActivityCommentStructuredHandler(CommentFactory commentFactory, ObjectFactory objectFactory, EvidenceReferenceHandler evidenceReferenceHandler) {
        this.commentFactory = commentFactory;
        this.objectFactory = objectFactory;
        CommentItemFactory itemFactory = new CommentItemFactory();
        itemFactory.setObjectFactory(objectFactory);
        itemFactory.setCommentFactory(commentFactory);
        this.reactionHandler = new ReactionHandler(commentFactory, objectFactory, evidenceReferenceHandler);
        this.physicReactionHandler = new PhysiologicalReactionHandler(commentFactory, objectFactory, evidenceReferenceHandler);
    }

    @Override
    public CatalyticActivityCommentStructured fromXmlBinding(uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType xmlObject) {
        CatalyticActivityCommentStructured comment = (CatalyticActivityCommentStructured)this.commentFactory.buildComment(CommentType.CATALYTIC_ACTIVITY);
        if (xmlObject.getMolecule() != null) {
            comment.setMolecule(xmlObject.getMolecule().getValue());
        }
        comment.setReaction(this.reactionHandler.fromXmlBinding(xmlObject.getReaction()));
        comment.setPhysiologicalReactions(xmlObject.getPhysiologicalReaction().stream().map(val -> this.physicReactionHandler.fromXmlBinding((PhysiologicalReactionType)val)).collect(Collectors.toList()));
        return comment;
    }

    @Override
    public uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType toXmlBinding(CatalyticActivityCommentStructured object) {
        uk.ac.ebi.kraken.xml.jaxb.uniprot.CommentType commentType = this.objectFactory.createCommentType();
        commentType.setType(object.getCommentType().toDisplayName().toLowerCase());
        if (!Strings.isNullOrEmpty((String)object.getMolecule())) {
            MoleculeType mol = this.objectFactory.createMoleculeType();
            mol.setValue(object.getMolecule());
            commentType.setMolecule(mol);
        }
        commentType.setReaction(this.reactionHandler.toXmlBinding(object.getReaction()));
        commentType.getPhysiologicalReaction().addAll(object.getPhysiologicalReactions().stream().map(val -> this.physicReactionHandler.toXmlBinding((PhysiologicalReaction)val)).collect(Collectors.toList()));
        return commentType;
    }
}

