/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot.citations.xrefs;

import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.AgricolaId;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationXrefs;
import uk.ac.ebi.kraken.xml.common.GenericHandler;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.DbReferenceType;
import uk.ac.ebi.kraken.xml.jaxb.uniprot.ObjectFactory;
import uk.ac.ebi.kraken.xml.uniprot.Constants;
import uk.ac.ebi.kraken.xml.uniprot.citations.xrefs.CitationXrefsStrategy;

public class AgricolaStrategy
implements CitationXrefsStrategy {
    private final GenericHandler<AgricolaId, String> agricolaIdHandler;
    private final ObjectFactory objectFactory;

    public AgricolaStrategy(GenericHandler<AgricolaId, String> agricolaIdHandler, ObjectFactory objectFactory) {
        this.agricolaIdHandler = agricolaIdHandler;
        this.objectFactory = objectFactory;
    }

    @Override
    public void fromJAXB(DbReferenceType referenceType, CitationXrefs citationXrefs) {
        if (referenceType.getType().equalsIgnoreCase(Constants.AGRICOLA_XMLTAG.getValue())) {
            citationXrefs.setAgricolaId(this.agricolaIdHandler.fromXmlBinding(referenceType.getId()));
        }
    }

    @Override
    public DbReferenceType toJAXB(CitationXrefs xrefs) {
        DbReferenceType dbReferenceXML = this.objectFactory.createDbReferenceType();
        String id = this.agricolaIdHandler.toXmlBinding(xrefs.getAgricolaId());
        if (id != null && id.length() > 0) {
            String name = Constants.AGRICOLA_XMLTAG.getValue();
            dbReferenceXML.setType(name);
            dbReferenceXML.setId(id);
            return dbReferenceXML;
        }
        return null;
    }
}

