/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.xml.uniprot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.kraken.interfaces.uniprot.Organism;

public class InternalReferenceHandler {
    private static final String delim = "$";
    private int keyCounter = 1;
    private Map<Integer, String> citationIndexToKey;
    private List<String> evidenceIdToIndex;
    private Map<String, String> dbIdToKey;
    private Map<String, String> organismToKey = new HashMap<String, String>();

    public InternalReferenceHandler() {
        this.citationIndexToKey = new HashMap<Integer, String>();
        this.dbIdToKey = new HashMap<String, String>();
        this.evidenceIdToIndex = new ArrayList<String>();
    }

    public String getIdForCitationIndex(Integer index) {
        return this.getId(index, this.citationIndexToKey);
    }

    public Integer getIndexForEvidenceId(String evidenceId) {
        for (int i = 0; i < this.evidenceIdToIndex.size(); ++i) {
            if (!this.evidenceIdToIndex.get(i).equalsIgnoreCase(evidenceId)) continue;
            return i + 1;
        }
        return -1;
    }

    public String getEvidenceIdForIndex(Integer evidenceIndex) {
        if (evidenceIndex > this.evidenceIdToIndex.size()) {
            return null;
        }
        return this.evidenceIdToIndex.get(evidenceIndex - 1);
    }

    public void putIndexForEvidenceId(String evidenceId) {
        if (!this.evidenceIdToIndex.contains(evidenceId)) {
            this.evidenceIdToIndex.add(evidenceId);
        }
    }

    public String getIdForDbCrossRef(String dbId, String dbName) {
        String id = this.buildXRefId(dbName, dbId);
        return this.getId(id, this.dbIdToKey);
    }

    private String buildXRefId(String dbName, String dbId) {
        StringBuilder sb = new StringBuilder();
        sb.append(dbName);
        sb.append(delim);
        sb.append(dbId);
        return sb.toString();
    }

    public String getIdForOrganism(Organism organism) {
        return this.getId(organism.getScientificName().getValue(), this.organismToKey);
    }

    private String getId(Object key, Map map) {
        String id = (String)map.get(key);
        if (id == null) {
            id = String.valueOf(this.keyCounter++);
            map.put(key, id);
        }
        return id;
    }

    public List<String> getEvidenceIdToIndex() {
        return this.evidenceIdToIndex;
    }
}

