/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.stringrange;

import uk.ac.ebi.kraken.util.stringrange.AllStringsIncluded;
import uk.ac.ebi.kraken.util.stringrange.ClosedStringRange;
import uk.ac.ebi.kraken.util.stringrange.ContainsStringRange;
import uk.ac.ebi.kraken.util.stringrange.SingleString;
import uk.ac.ebi.kraken.util.stringrange.StartsWith;
import uk.ac.ebi.kraken.util.stringrange.StringRange;

public class StringRangeFactory {
    public static StringRange newAllStringsIncluded() {
        StringRangeFactory factory = new StringRangeFactory();
        return factory.createNewAllStringsIncluded();
    }

    public static StringRange newSingleString(String value) {
        StringRangeFactory factory = new StringRangeFactory();
        return factory.createNewSingleString(value);
    }

    public static StringRange newStartsWithString(String value) {
        StringRangeFactory factory = new StringRangeFactory();
        return factory.createNewStartsWithString(value);
    }

    public static StringRange newContainsString(String value) {
        StringRangeFactory factory = new StringRangeFactory();
        return factory.createNewContainsString(value);
    }

    public static StringRange newClosedStringRange(String start, String end) {
        return StringRangeFactory.newClosedStringRange(start, end, true, true);
    }

    public static StringRange newClosedStringRange(String start, String end, boolean leftClosed, boolean rightClosed) {
        StringRangeFactory factory = new StringRangeFactory();
        return factory.createNewClosedStringRange(start, end, leftClosed, rightClosed);
    }

    private StringRange createNewAllStringsIncluded() {
        return new AllStringsIncluded();
    }

    private StringRange createNewContainsString(String value) {
        return new ContainsStringRange(value);
    }

    private StringRange createNewStartsWithString(String value) {
        return new StartsWith(value);
    }

    private StringRange createNewSingleString(String value) {
        return new SingleString(value);
    }

    private StringRange createNewClosedStringRange(String start, String end, boolean leftClosed, boolean rightClosed) {
        return new ClosedStringRange(start, end, leftClosed, rightClosed);
    }
}

