/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.string;

import java.text.Normalizer;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.regex.Pattern;

public final class StringUtil {
    private static final String GERMAN_B = "\u00df";
    private static final String GERMAN_B_REPLACEMENT = "ss";

    private StringUtil() {
    }

    public static String removeDiacritics(String s) {
        String temp = Normalizer.normalize(s, Normalizer.Form.NFD);
        temp = temp.replaceAll(GERMAN_B, GERMAN_B_REPLACEMENT);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(temp).replaceAll("");
    }

    public static String preprocessMsgSafe(String msg, Object ... params) {
        if (null != msg && params.length > 0 && msg.trim().length() > 0) {
            try {
                msg = String.format(msg, params);
            }
            catch (IllegalFormatException ife) {
                String paramsJoint = Arrays.toString(params);
                System.err.format("Error formatting initial msg: '%s' with params: %s. Error: %s%n", msg, paramsJoint, ife.getMessage());
                msg = msg + "', parameterised by: " + paramsJoint;
            }
        }
        return msg;
    }

    public static boolean isNotAsciiString(String str) {
        if (str == null || str.length() == 0) {
            return false;
        }
        return str.chars().anyMatch(val -> val < 0 || val > 255);
    }

    public static String firstLetterCaps(String data) {
        String firstLetter = data.substring(0, 1).toUpperCase();
        String restLetters = data.substring(1).toLowerCase();
        return firstLetter + restLetters;
    }
}

