/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.parser;

public class StringDataParser {
    public static String replace(String val, String oldS, String newS) {
        String text = val;
        while (text.contains(oldS)) {
            text = text.replace(oldS, newS);
        }
        return text;
    }

    public static String trimSpaces(String val) {
        String localVal = val;
        if (localVal == null) {
            return null;
        }
        localVal = localVal.trim();
        localVal = localVal.replaceAll("\\s+", " ");
        return localVal;
    }

    public static String removeECNumbers(String val) {
        String localVal = val;
        if (localVal == null) {
            return null;
        }
        localVal = localVal.replaceAll("\\(EC .+?\\)", "");
        return localVal;
    }

    public static String removeEvidenceTags(String val) {
        String localVal = val;
        if (localVal == null) {
            return null;
        }
        localVal = localVal.replaceAll("\\(ECO:\\d{7}\\|.+:.+\\)|\\(ECO:\\d{7}.*?\\)", "");
        localVal = localVal.replaceAll("\\{ECO:\\d{7}\\|.+:.+\\}|\\{ECO:\\d{7}.*?\\}", "");
        return localVal;
    }

    public static String trimDuplicateInMiddle(String val) {
        String text = val;
        text = StringDataParser.replace(text, " ,", ",");
        text = StringDataParser.replace(text, "  ", " ");
        text = StringDataParser.replace(text, " .", ".");
        text = StringDataParser.replace(text, " ;", ";");
        text = StringDataParser.replace(text, " :", ":");
        text = StringDataParser.replace(text, ";;", ";");
        text = StringDataParser.replace(text, ",,", ",");
        return text;
    }

    public static String trimSingleDoubleQuote(String val) {
        if (val == null) {
            return val;
        }
        String doubleQuote = "\"";
        int firstIndex = val.indexOf(doubleQuote);
        if (firstIndex == -1) {
            return val;
        }
        int lastIndex = val.lastIndexOf(doubleQuote);
        if (firstIndex != lastIndex) {
            return val;
        }
        return val.replace(doubleQuote, "");
    }

    public static String uncharacterizeProtein(String val) {
        String localVal = val;
        if (localVal == null) {
            return null;
        }
        localVal = localVal.replaceAll("ncharacterised", "ncharacterized");
        localVal = localVal.replaceAll("ncharcterised", "ncharacterized");
        localVal = localVal.replaceAll("Putative uncharacterized", "Uncharacterized");
        return localVal;
    }

    public static String bySimilarity(String val) {
        String localVal = val;
        if (localVal == null) {
            return null;
        }
        localVal = localVal.replace("(By similarity)", "By similarity");
        return localVal;
    }

    public static String replaceDoubleQuoteWithSingleQuote(String val) {
        if (val == null) {
            return null;
        }
        val = val.replaceAll("\"", "'");
        return val;
    }
}

