/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.objectcounter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import uk.ac.ebi.kraken.util.objectcounter.AbstractObjectCounter;
import uk.ac.ebi.kraken.util.objectcounter.CountedObject;
import uk.ac.ebi.kraken.util.objectcounter.ObjectCounter;

public class DefaultObjectCounter<T>
extends AbstractObjectCounter<T>
implements ObjectCounter<T>,
Serializable {
    private Map<T, Integer> objectCounter = new HashMap<T, Integer>();

    @Override
    public void add(T obj, int num) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        if (num < 0) {
            throw new IllegalArgumentException();
        }
        if (num == 0) {
            return;
        }
        if (this.objectCounter.containsKey(obj)) {
            this.objectCounter.put(obj, this.objectCounter.get(obj) + num);
        } else {
            this.objectCounter.put(obj, num);
        }
    }

    @Override
    public boolean remove(T obj, int n) {
        if (obj == null || n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0 || this.objectCounter.get(obj) == null) {
            return false;
        }
        int num = this.objectCounter.get(obj);
        if (num - n <= 0) {
            this.objectCounter.remove(obj);
        } else {
            this.objectCounter.put(obj, num - n);
        }
        return true;
    }

    @Override
    public boolean containsObject(T key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.objectCounter.containsKey(key);
    }

    @Override
    public int countObject(T obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        if (!this.objectCounter.containsKey(obj)) {
            return 0;
        }
        return this.objectCounter.get(obj);
    }

    @Override
    public Collection<T> getDistinctObjects() {
        return this.objectCounter.keySet();
    }

    @Override
    public Collection<T> getMostFrequentObjects(int n) {
        return this.getFrequentObjects(n, 1);
    }

    @Override
    public Collection<T> getLeastFrequentObjects(int n) {
        return this.getFrequentObjects(n, 2);
    }

    private List<T> getFrequentObjects(int n, int order) {
        TreeSet<CountedObject<T>> result = new TreeSet<CountedObject<T>>();
        Set<T> set = this.objectCounter.keySet();
        for (T s : set) {
            int value = this.objectCounter.get(s);
            result.add(new CountedObject<T>(s, value, order));
        }
        ArrayList list = new ArrayList();
        int size = 0;
        for (CountedObject countedObject : result) {
            if (++size > n) break;
            list.add(countedObject.getObject());
        }
        return list;
    }

    @Override
    public List<T> getSortedObjects(int sortingOrder) {
        if (sortingOrder != 0 && sortingOrder != 1) {
            throw new IllegalArgumentException();
        }
        return this.getFrequentObjects(this.getDistinctObjects().size(), sortingOrder);
    }
}

