/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.objectcounter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import uk.ac.ebi.kraken.util.objectcounter.ObjectCounter;

public abstract class AbstractObjectCounter<T>
implements ObjectCounter<T> {
    @Override
    public void add(T obj) {
        this.add(obj, 1);
    }

    @Override
    public void addAll(T[] tArray) {
        if (tArray == null) {
            throw new IllegalArgumentException();
        }
        for (T s : tArray) {
            this.add(s, 1);
        }
    }

    @Override
    public void addAll(Collection<T> input) {
        if (input == null) {
            throw new IllegalArgumentException();
        }
        for (T s : input) {
            this.add(s, 1);
        }
    }

    @Override
    public void addAll(ObjectCounter<T> oc) {
        if (oc == null) {
            throw new IllegalArgumentException();
        }
        Collection<T> otherObjects = oc.getDistinctObjects();
        for (T key : otherObjects) {
            int othervalue = oc.countObject(key);
            this.add(key, othervalue);
        }
    }

    @Override
    public boolean remove(T obj) {
        return this.remove(obj, 1);
    }

    @Override
    public boolean removeAll(T obj) {
        return this.remove(obj, this.countObject(obj));
    }

    @Override
    public boolean removeAll(T[] array) {
        if (array == null) {
            throw new IllegalArgumentException();
        }
        boolean result = false;
        for (T object : array) {
            result = this.remove(object) || result;
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException();
        }
        boolean result = false;
        for (T object : collection) {
            result = this.remove(object) || result;
        }
        return result;
    }

    @Override
    public boolean removeAll(ObjectCounter<T> oc) {
        if (oc == null) {
            throw new IllegalArgumentException();
        }
        boolean result = false;
        Collection<T> otherObjects = oc.getDistinctObjects();
        for (T key : otherObjects) {
            int othervalue;
            result = this.remove(key, othervalue = oc.countObject(key)) || result;
        }
        return result;
    }

    @Override
    public int countAllObjects() {
        int result = 0;
        for (Object o : this.getDistinctObjects()) {
            result += this.countObject(o);
        }
        return result;
    }

    @Override
    public int countAllObjects(Class<?> clazz, boolean distinct) {
        int result = 0;
        for (Object o : this.getDistinctObjects()) {
            if (!clazz.isAssignableFrom(o.getClass())) continue;
            if (distinct) {
                ++result;
                continue;
            }
            result += this.countObject(o);
        }
        return result;
    }

    @Override
    public List<T> getObjectsFromFrequency(int n, int operator) {
        ArrayList result = new ArrayList();
        List sortedList = operator == 0 || operator == 1 || operator == 2 ? this.getSortedObjects(0) : this.getSortedObjects(1);
        for (Object obj : sortedList) {
            int count = this.countObject(obj);
            if (count < n) {
                if (operator != 0 && operator != 1) continue;
                result.add(obj);
                continue;
            }
            if (count > n) {
                if (operator != 4 && operator != 3) continue;
                result.add(obj);
                continue;
            }
            if (operator != 3 && operator != 1 && operator != 2) continue;
            result.add(obj);
        }
        return result;
    }
}

