/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.net;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.util.net.FtpService;

public class FtpServiceImpl
implements FtpService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FtpServiceImpl.class);
    private FTPClient ftpClient;
    private String domainHost;
    private String username;
    private String password;
    private boolean usingProxy = false;

    public FtpServiceImpl() {
        this.ftpClient = new FTPClient();
        String host = System.getProperty("http.proxyHost");
        String port = System.getProperty("http.proxyPort");
        if (host != null && !host.isEmpty() && port != null && !port.isEmpty()) {
            LOGGER.info("detected proxy: {}, {}", (Object)host, (Object)port);
            InetSocketAddress addr = new InetSocketAddress(host, (int)Integer.valueOf(port));
            this.ftpClient.setProxy(new Proxy(Proxy.Type.HTTP, addr));
            this.usingProxy = true;
        }
    }

    public FtpServiceImpl(FTPClient ftpClient) {
        this.ftpClient = ftpClient;
    }

    @Override
    public boolean connect(String domainHost, String username, String password) throws IOException {
        boolean isConnected = false;
        this.domainHost = domainHost;
        this.username = username;
        this.password = password;
        this.ftpClient.connect(domainHost);
        LOGGER.info(this.ftpClient.getReplyString());
        isConnected = this.ftpClient.login(username, password);
        LOGGER.info(this.ftpClient.getReplyString());
        if (this.usingProxy) {
            this.ftpClient.enterLocalPassiveMode();
        }
        return isConnected;
    }

    @Override
    public boolean reconnect(int attempts) throws IOException {
        int performedAttempts = 0;
        while (true) {
            this.releaseConnection();
            try {
                this.ftpClient.connect(this.domainHost);
                LOGGER.info(this.ftpClient.getReplyString());
                this.ftpClient.login(this.username, this.password);
                LOGGER.info(this.ftpClient.getReplyString());
            }
            catch (ConnectException e) {
                if (++performedAttempts < attempts) continue;
            }
            break;
        }
        return this.ftpClient.isConnected();
    }

    @Override
    public Calendar getLastModifiedFromFile(String workingDirectory, String fileName) throws IOException {
        FTPFile[] ftpFiles;
        Calendar lastModified = null;
        this.ftpClient.enterLocalPassiveMode();
        if (!workingDirectory.equals("")) {
            this.ftpClient.changeWorkingDirectory(workingDirectory);
        }
        if ((ftpFiles = this.ftpClient.listFiles(fileName)).length > 1) {
            throw new IllegalArgumentException("There are more than one file for the specified directory and fileName: " + workingDirectory + fileName);
        }
        lastModified = ftpFiles[0].getTimestamp();
        return lastModified;
    }

    @Override
    public boolean downloadCollectingMultipleTextFiles(List<String> remoteFilePaths, String newFilePath) throws IOException {
        boolean isDownloaded = false;
        try (FileOutputStream outputStream = new FileOutputStream(newFilePath);){
            this.ftpClient.enterLocalPassiveMode();
            LOGGER.info(this.ftpClient.getReplyString());
            for (String remoteFilePath : remoteFilePaths) {
                isDownloaded = this.ftpClient.retrieveFile(remoteFilePath, (OutputStream)outputStream);
                LOGGER.info(this.ftpClient.getReplyString());
            }
        }
        return isDownloaded;
    }

    @Override
    public boolean download(String remoteFilePath, String newFilePath, boolean isBinaryFile) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(newFilePath);){
            if (isBinaryFile) {
                this.ftpClient.setFileType(2);
                LOGGER.info(this.ftpClient.getReplyString());
            }
            if (this.ftpClient.retrieveFile(remoteFilePath, (OutputStream)outputStream)) {
                LOGGER.info(this.ftpClient.getReplyString());
                if (isBinaryFile) {
                    this.ftpClient.setFileType(2);
                    LOGGER.info(this.ftpClient.getReplyString());
                }
                LOGGER.info(this.ftpClient.getReplyString());
                LOGGER.info("Downloaded: {}", (Object)newFilePath);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public boolean read(String remoteFilePath, OutputStream outputStream, boolean isBinaryFile) throws IOException {
        boolean isDownloaded = false;
        this.ftpClient.enterLocalPassiveMode();
        LOGGER.info(this.ftpClient.getReplyString());
        if (isBinaryFile) {
            this.ftpClient.setFileType(2);
            LOGGER.info(this.ftpClient.getReplyString());
        }
        isDownloaded = this.ftpClient.retrieveFile(remoteFilePath, outputStream);
        LOGGER.info(this.ftpClient.getReplyString());
        return isDownloaded;
    }

    @Override
    public void releaseConnection() {
        try {
            if (this.ftpClient.isConnected()) {
                this.ftpClient.logout();
                this.ftpClient.disconnect();
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean downMultipleTextFilesFromDirectory(String remoteDir, String newFilePath) throws IOException {
        boolean isDownloaded = false;
        try (FileOutputStream outputStream = new FileOutputStream(newFilePath);){
            LOGGER.info(this.ftpClient.getReplyString());
            FTPFile[] list = this.ftpClient.listFiles(remoteDir);
            LOGGER.info("There are " + list.length + " files under " + remoteDir);
            int count = 0;
            for (FTPFile file : list) {
                if (!file.isFile()) continue;
                ++count;
                LOGGER.info(file.getName());
                isDownloaded = this.ftpClient.retrieveFile(remoteDir + "/" + file.getName(), (OutputStream)outputStream);
                LOGGER.info(this.ftpClient.getReplyString());
            }
            LOGGER.info(count + " files downloaded");
        }
        return isDownloaded;
    }

    @Override
    public List<String> findFileFromDirectory(String path, String pattern) throws IOException {
        FTPFile[] list;
        ArrayList<String> foundFiles = new ArrayList<String>();
        for (FTPFile file : list = this.ftpClient.listFiles(path)) {
            if (!file.isFile()) continue;
            file.getName();
            Pattern filenamePattern = Pattern.compile(pattern);
            Matcher filenameMatcher = filenamePattern.matcher(file.getName());
            if (!filenameMatcher.find()) continue;
            foundFiles.add(file.getName());
        }
        return foundFiles;
    }

    @Override
    public void setControlKeepAliveTimeout(int timeout) {
        this.ftpClient.setControlKeepAliveTimeout((long)timeout);
    }

    @Override
    public byte[] getFileIntoMemory(String assemblyFile, ByteArrayOutputStream outputStream, boolean isBinary) throws IOException {
        if (this.reconnect(10) && this.read(assemblyFile, outputStream, isBinary)) {
            return outputStream.toByteArray();
        }
        throw new FileNotFoundException("Could not retrieve file from FTP");
    }

    @Override
    public boolean isConnected() {
        return this.ftpClient.isConnected();
    }
}

