/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.jdom;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentUtils {
    private DocumentUtils() {
    }

    public static Node getFirstChildNode(String childName, Node parent) {
        if (parent == null || childName == null) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        for (int iii = 0; iii < children.getLength(); ++iii) {
            Node child = children.item(iii);
            if (!child.getNodeName().equals(childName)) continue;
            return child;
        }
        return null;
    }

    public static Node getFirstChildNode(String childName, String attribute, String value, Node parent) {
        if (parent == null || childName == null || attribute == null || value == null) {
            return null;
        }
        NodeList targets = parent.getChildNodes();
        for (int iii = 0; iii < targets.getLength(); ++iii) {
            NamedNodeMap nnm;
            Node type;
            Node target = targets.item(iii);
            if (!target.getNodeName().equals(childName) || !value.equals((type = (nnm = target.getAttributes()).getNamedItem(attribute)).getNodeValue())) continue;
            return target;
        }
        return null;
    }

    public static String getAttributeValue(String attribute, Node node) {
        NamedNodeMap nodeAttributes = node.getAttributes();
        if (nodeAttributes == null) {
            return "";
        }
        Node namedItem = nodeAttributes.getNamedItem(attribute);
        if (namedItem == null) {
            return "";
        }
        return namedItem.getNodeValue();
    }

    public static boolean isAttributeValue(String attribute, Node node, String value) {
        String attributeValue = DocumentUtils.getAttributeValue(attribute, node);
        return !attributeValue.equals("") && attributeValue.equals(value);
    }

    public static List<Node> getChildNodes(String childName, Node parent) {
        ArrayList<Node> result = new ArrayList<Node>();
        NodeList nodeList = parent.getChildNodes();
        for (int iii = 0; iii < nodeList.getLength(); ++iii) {
            Node node = nodeList.item(iii);
            if (!node.getNodeName().equals(childName)) continue;
            result.add(node);
        }
        return result;
    }
}

