/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.generator;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.util.generator.TokenTree;

public class CommentGenerator {
    public static void main(String[] args) {
        String prefix = "";
        if (args.length == 1) {
            prefix = args[0];
        }
        String yaspLocation = prefix + "src/antlr/swissprot/yasp.g";
        String lexerLocation = prefix + "src/main/uk/ac/ebi/kraken/parser/DefaultSwissprotLexer.java";
        try {
            CommentGenerator.yasp(yaspLocation);
            CommentGenerator.spLexer(lexerLocation);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void spLexer(String file) throws Exception {
        TokenTree tt = new TokenTree();
        for (CommentType type : CommentType.values()) {
            String token = type.toDisplayName();
            tt.addToken(token + ":");
        }
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.trim().equals("// comment block: Do not delete this comment")) {
                sb.append(line + "\n");
                sb.append(tt.toCCSwitchStatement());
                while (!(line = reader.readLine()).trim().equals("// end comment block: Do not delete this comment")) {
                }
                sb.append(line + "\n");
                continue;
            }
            sb.append(line + "\n");
        }
        reader.close();
        FileWriter fw = new FileWriter(file);
        fw.write(sb.toString());
        fw.flush();
        fw.close();
    }

    public static void yasp(String file) throws Exception {
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        List<String> methods = CommentGenerator.getMethods();
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.trim().equals("// cc list is generated automatically (don't remove this comment line!)")) {
                sb.append(line + "\n");
                Iterator<String> it = methods.iterator();
                while (it.hasNext()) {
                    sb.append("            " + it.next());
                    if (it.hasNext()) {
                        sb.append(" |\n");
                        continue;
                    }
                    sb.append("\n");
                }
                while (!(line = reader.readLine()).trim().equals("// end cc list generation (don't remove this comment line!)")) {
                }
                sb.append(line + "\n");
                continue;
            }
            if (line.trim().equals("// cc token definition (don't remove this comment line!)")) {
                sb.append(line + "\n");
                for (String method : CommentGenerator.getMethods()) {
                    sb.append(CommentGenerator.getTokenName(method) + ": \"" + CommentGenerator.getDisplayName(method) + "\";\n");
                }
                while (!(line = reader.readLine()).trim().equals("// cc token definition ends (don't remove this comment line!)")) {
                }
                sb.append(line + "\n");
                continue;
            }
            if (line.trim().equals("// comment definitions (don't remove this comment line!)")) {
                sb.append(line + "\n");
                while (!(line = reader.readLine()).trim().equals("// end comment definitions (don't remove this comment line!)")) {
                }
                for (String method : methods) {
                    sb.append("/**\n");
                    sb.append("* Parses the <code>CC   " + CommentGenerator.getDisplayName(method) + "</code> line\n");
                    sb.append("*/\n");
                    sb.append("// comment (don't remove this comment line!)\n");
                    sb.append(method + "\n");
                    sb.append(":\n");
                    sb.append("    CC\n");
                    sb.append("    " + CommentGenerator.getTokenName(method) + "\n");
                    sb.append("    {\n");
                    sb.append("        \tStringBuffer sb = new StringBuffer();\n");
                    sb.append("            sb.append(parseRest());\n");
                    sb.append("            linenumber++;\n");
                    sb.append("        }\n");
                    sb.append("    (\n");
                    sb.append("        CCCONTINUE\n");
                    sb.append("            {\n");
                    if (CommentGenerator.isLineBreakConserved(CommentGenerator.getCommentType(method))) {
                        sb.append("                sb.append(\"\\n\"+parseRest());\n");
                    } else {
                        sb.append("                if (!sb.toString().endsWith(\"-\")) {\n");
                        sb.append("                    sb.append(' ');\n");
                        sb.append("                }\n");
                        sb.append("                sb.append(parseRest());\n");
                    }
                    sb.append("                linenumber++;\n");
                    sb.append("            }\n");
                    sb.append("    )*\n");
                    sb.append("    {\n");
                    sb.append(CommentGenerator.getContent(method));
                    sb.append("    }\n");
                    sb.append(";\n");
                }
                sb.append(line + "\n");
                continue;
            }
            sb.append(line + "\n");
        }
        reader.close();
        FileWriter fw = new FileWriter(file);
        fw.write(sb.toString());
        fw.flush();
        fw.close();
    }

    private static List<String> getMethods() {
        ArrayList<String> result = new ArrayList<String>();
        CommentType[] types = CommentType.values();
        for (int iii = 0; iii < types.length; ++iii) {
            CommentType type = types[iii];
            result.add("cc" + type.toString().toLowerCase());
        }
        return result;
    }

    private static String getTokenName(String method) {
        CommentType[] types = CommentType.values();
        for (int iii = 0; iii < types.length; ++iii) {
            CommentType type = types[iii];
            String ctMethod = "cc" + type.toString().replaceAll(" ", "").toLowerCase();
            if (!method.equals(ctMethod)) continue;
            return type.toString();
        }
        return null;
    }

    private static CommentType getCommentType(String method) {
        CommentType[] types = CommentType.values();
        for (int iii = 0; iii < types.length; ++iii) {
            CommentType type = types[iii];
            String ctMethod = "cc" + type.toString().replaceAll(" ", "").toLowerCase();
            if (!method.equals(ctMethod)) continue;
            return type;
        }
        return null;
    }

    private static String getDisplayName(String method) {
        CommentType[] types = CommentType.values();
        for (int iii = 0; iii < types.length; ++iii) {
            CommentType type = types[iii];
            String ctMethod = "cc" + type.toString().replaceAll(" ", "").toLowerCase();
            if (!method.equals(ctMethod)) continue;
            return type.toDisplayName();
        }
        return null;
    }

    private static String getContent(String method) {
        return "";
    }

    private static boolean isLineBreakConserved(CommentType type) {
        switch (type) {
            case INTERACTION: {
                return true;
            }
        }
        return false;
    }
}

