/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util.container;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import uk.ac.ebi.kraken.util.container.ModifiableCollection;

public class MapValueCollection<T>
extends ModifiableCollection<T> {
    Collection<List<? extends T>> mapValues = null;
    int size = 0;

    public MapValueCollection(Consumer<T> collectionVisitor, Collection<List<? extends T>> mapValues) {
        super(collectionVisitor);
        this.mapValues = mapValues;
        for (List<T> list : mapValues) {
            this.size += list.size();
        }
    }

    @Override
    public boolean add(T o) {
        super.add(o);
        ++this.size;
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new MapValueIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    class MapValueIterator<T>
    implements Iterator<T> {
        Iterator iter;
        List<? extends T> currentList;
        boolean removed;
        int currentListPointer;
        int overallPointer;

        MapValueIterator() {
            this.iter = MapValueCollection.this.mapValues.iterator();
            this.currentListPointer = 0;
            this.overallPointer = 0;
        }

        @Override
        public boolean hasNext() {
            return this.overallPointer < MapValueCollection.this.size;
        }

        private void getNextCurrentList() {
            if (!this.iter.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentList = (List)this.iter.next();
            this.currentListPointer = 0;
        }

        @Override
        public T next() {
            if (this.currentList == null) {
                this.getNextCurrentList();
            }
            while (this.currentListPointer == this.currentList.size()) {
                this.getNextCurrentList();
            }
            T retVal = this.currentList.get(this.currentListPointer);
            ++this.currentListPointer;
            ++this.overallPointer;
            this.removed = false;
            return retVal;
        }

        @Override
        public void remove() {
            if (this.removed) {
                throw new IllegalStateException();
            }
            if (this.currentList == null) {
                throw new NoSuchElementException();
            }
            this.currentList.remove(this.currentListPointer - 1);
            --MapValueCollection.this.size;
            --this.currentListPointer;
            --this.overallPointer;
            this.removed = true;
        }
    }
}

