/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.util;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailUtil.class);

    private MailUtil() {
    }

    public static void sendMail(String from, List<String> addrs, String subject, String text, String attachedFile) throws Exception {
        MailUtil.sendMail(from, addrs, subject, text, Collections.singletonList(attachedFile));
    }

    public static void sendMail(String from, List<String> addrs, String subject, String text) throws Exception {
        MailUtil.sendMail(from, addrs, subject, text, Collections.emptyList());
    }

    public static void sendMail(String from, List<String> addrs, String subject, String text, List<String> attachedFiles) throws Exception {
        LOGGER.debug("sendMail");
        Properties props = System.getProperties();
        props.put("mail.host", "smtp.ebi.ac.uk");
        Session mailConnection = Session.getDefaultInstance((Properties)props, null);
        LOGGER.info("sendMail");
        MimeMessage msg = new MimeMessage(mailConnection);
        InternetAddress fromA = new InternetAddress(from, from);
        msg.setFrom((Address)fromA);
        for (String to : addrs) {
            InternetAddress toA = new InternetAddress(to);
            msg.addRecipient(Message.RecipientType.TO, (Address)toA);
        }
        msg.setSubject(subject);
        MimeBodyPart textPart = new MimeBodyPart();
        if (attachedFiles.size() > 1) {
            textPart.setContent((Object)text, "text/html");
        } else {
            textPart.setContent((Object)text, "text/plain");
        }
        MimeMultipart mp = new MimeMultipart();
        mp.addBodyPart((BodyPart)textPart);
        for (String attachment : attachedFiles) {
            MimeBodyPart attachFilePart = new MimeBodyPart();
            FileDataSource fds = new FileDataSource(attachment);
            if (fds.getFile().length() / 0x100000L < 2L) {
                attachFilePart.setDataHandler(new DataHandler((DataSource)fds));
                attachFilePart.setFileName(fds.getName());
            } else {
                attachFilePart.setText(fds.getFile().getAbsolutePath() + ", size " + fds.getFile().length() / 1024L + "KB");
            }
            mp.addBodyPart((BodyPart)attachFilePart);
        }
        msg.setContent((Multipart)mp);
        Transport.send((Message)msg);
    }
}

