/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser.translator;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Position;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingComment;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingLocationType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.RnaEditingNote;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.parser.translator.CommentTranslator;
import uk.ac.ebi.kraken.parser.translator.CommentTranslatorHelper;

public class RnaEditingCommentTranslator
implements CommentTranslator<RnaEditingComment> {
    private static final String UNKNOWN = "Unknown";
    private static final String UNDETERMINED = "Undetermined";
    private static final String NOT_APPLICABLE = "Not_applicable";
    private static final String NOTE = "Note=";
    private static final String MODIFIED_POSITIONS = "Modified_positions=";
    private static final DefaultCommentFactory FACTORY = DefaultCommentFactory.getInstance();
    private static final CommentType COMMENT_TYPE = CommentType.RNA_EDITING;

    @Override
    public RnaEditingComment translate(String annotation) {
        RnaEditingComment comment = (RnaEditingComment)FACTORY.buildComment(COMMENT_TYPE);
        annotation = CommentTranslatorHelper.trimCommentHeader(annotation, COMMENT_TYPE);
        this.translate(annotation, comment);
        return comment;
    }

    private String updateMolecule(String annotation, RnaEditingComment comment) {
        if (annotation.startsWith("[") && annotation.contains("]")) {
            int index = annotation.indexOf("]");
            String molecule = annotation.substring(1, index);
            molecule = molecule.replaceAll("\n", " ");
            comment.setMolecule(molecule);
            annotation = annotation.substring(index + 2).trim();
            if (annotation.startsWith("\n")) {
                annotation = annotation.substring(1);
            }
            return annotation;
        }
        return annotation;
    }

    @Override
    public void translate(String annotation, RnaEditingComment comment) {
        String[] tokens;
        annotation = CommentTranslatorHelper.stripTrailing(annotation, ";");
        annotation = this.updateMolecule(annotation, comment);
        int noteIndex = annotation.indexOf("; Note=");
        String noteStr = null;
        if (noteIndex != -1) {
            noteStr = annotation.substring(noteIndex + "; Note=".length());
            annotation = annotation.substring(0, noteIndex);
        }
        for (String token : tokens = annotation.split(";")) {
            if (!(token = token.trim()).startsWith(MODIFIED_POSITIONS)) continue;
            token = token.substring(MODIFIED_POSITIONS.length());
            List<String> poses = this.splitPosition(token);
            RnaEditingLocationType type = this.getLocationType(poses);
            comment.setLocationType(type);
            if (type != RnaEditingLocationType.Known) continue;
            ArrayList<Position> positions = new ArrayList<Position>();
            for (String pos : poses) {
                pos = pos.trim();
                Position position = FACTORY.buildRnaEditingPosition();
                ArrayList<EvidenceId> evidences = new ArrayList<EvidenceId>();
                pos = CommentTranslatorHelper.stripEvidenceIds(pos, evidences);
                position.setEvidenceIds(evidences);
                position.setPosition(pos);
                positions.add(position);
            }
            comment.setPositions(positions);
        }
        if (noteStr != null) {
            RnaEditingNote note = FACTORY.buildRnaEditingNote();
            note.setTexts(CommentTranslatorHelper.parseEvidencedValues(noteStr, true));
            comment.setRnaEditingNote(note);
        }
    }

    private List<String> splitPosition(String pos) {
        ArrayList<String> positions = new ArrayList<String>();
        String sep = ", ";
        String eCO = "ECO:";
        int index = 0;
        int start = 0;
        do {
            if ((index = pos.indexOf(sep, start)) == -1) {
                positions.add(pos);
                break;
            }
            String sub = pos.substring(index + 2);
            if (sub.startsWith(eCO)) {
                start = index + 2;
                continue;
            }
            String pos1 = pos.substring(0, index);
            pos = pos.substring(index + 2);
            positions.add(pos1);
            start = 0;
        } while (index != -1);
        return positions;
    }

    private RnaEditingLocationType getLocationType(List<String> poses) {
        if (poses.size() > 1) {
            return RnaEditingLocationType.Known;
        }
        if (poses.get(0).startsWith(NOT_APPLICABLE)) {
            return RnaEditingLocationType.Not_applicable;
        }
        if (poses.get(0).startsWith(UNDETERMINED)) {
            return RnaEditingLocationType.Undetermined;
        }
        if (poses.get(0).startsWith(UNKNOWN)) {
            return RnaEditingLocationType.Unknown;
        }
        return RnaEditingLocationType.Known;
    }
}

