/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import uk.ac.ebi.kraken.interfaces.factories.UniProtFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtEntry;
import uk.ac.ebi.kraken.parser.EntryIterator;
import uk.ac.ebi.kraken.parser.FlatFileLoader;
import uk.ac.ebi.kraken.parser.UniProtParserException;
import uk.ac.ebi.uniprot.parser.ParseException;
import uk.ac.ebi.uniprot.parser.UniprotLineParser;
import uk.ac.ebi.uniprot.parser.impl.DefaultUniprotLineParserFactory;
import uk.ac.ebi.uniprot.parser.impl.entry.EntryObject;
import uk.ac.ebi.uniprot.parser.impl.entry.EntryObjectConverter;

public final class UniProtParser {
    private static final ThreadLocal<UniprotLineParser<EntryObject>> ENTRY_PARSER = ThreadLocal.withInitial(() -> new DefaultUniprotLineParserFactory().createEntryParser());
    private static final ThreadLocal<EntryObjectConverter> ENTRY_OBJECT_CONVERTER = ThreadLocal.withInitial(EntryObjectConverter::new);
    private static final ThreadLocal<EntryObjectConverter> ENTRY_OBJECT_CONVERTER_IGNORE_DR = ThreadLocal.withInitial(() -> new EntryObjectConverter(true));

    private UniProtParser() {
    }

    public static UniProtEntry parse(String entryText, UniProtFactory factory) throws UniProtParserException {
        return UniProtParser.parse(entryText, factory, false);
    }

    public static UniProtEntry parse(String entryText, UniProtFactory factory, boolean ignoreWrongDR) throws UniProtParserException {
        try {
            EntryObject parse = ENTRY_PARSER.get().parse(entryText);
            EntryObjectConverter entryConverter = ENTRY_OBJECT_CONVERTER.get();
            if (ignoreWrongDR) {
                entryConverter = ENTRY_OBJECT_CONVERTER_IGNORE_DR.get();
            }
            return entryConverter.convert(parse);
        }
        catch (ParseException e) {
            e.printStackTrace();
            System.err.println(entryText);
            throw new UniProtParserException(e.getDetailedMessage());
        }
        catch (RuntimeException ee) {
            ee.printStackTrace();
            System.err.println(entryText);
            throw ee;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UniProtEntry parse(URL url, UniProtFactory factory, boolean ignoreWrongDR) throws UniProtParserException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));){
            FlatFileLoader l = new FlatFileLoader(in);
            UniProtEntry uniProtEntry = UniProtParser.parse(l.getNextEntry(), factory, ignoreWrongDR);
            return uniProtEntry;
        }
        catch (Exception ioe) {
            throw new UniProtParserException(ioe, -1);
        }
    }

    public static UniProtEntry parse(InputStream inputStream, UniProtFactory factory) throws UniProtParserException {
        return UniProtParser.parse(inputStream, factory, false);
    }

    public static UniProtEntry parse(InputStream inputStream, UniProtFactory factory, boolean ignoreWrongDR) throws UniProtParserException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            FlatFileLoader flatFileLoader = new FlatFileLoader(reader);
            return UniProtParser.parse(flatFileLoader.getNextEntry(), factory, ignoreWrongDR);
        }
        catch (Exception e) {
            throw new UniProtParserException(e, -1);
        }
    }

    public static UniProtEntry parse(File file, UniProtFactory factory) {
        EntryIterator it = UniProtParser.parseEntriesAll(file, factory);
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public static EntryIterator parseEntriesAll(File file, UniProtFactory factory, boolean ignoreWrongDR) {
        if (factory == null || file == null) {
            throw new IllegalArgumentException();
        }
        return new EntryIterator(factory, file, ignoreWrongDR);
    }

    public static EntryIterator parseEntriesAll(File file, UniProtFactory factory) {
        return UniProtParser.parseEntriesAll(file, factory, false);
    }

    public static Iterator<UniProtEntry> parseAll(File file, UniProtFactory factory, boolean ignoreWrongDR) {
        if (factory == null || file == null) {
            throw new IllegalArgumentException();
        }
        return new EntryIterator(factory, file, ignoreWrongDR);
    }

    public static Iterator<UniProtEntry> parseAll(File file, UniProtFactory factory) {
        return UniProtParser.parseAll(file, factory, false);
    }

    public static EntryIterator parseAll(InputStream inputStream, UniProtFactory factory) {
        return new EntryIterator(factory, inputStream);
    }

    public static EntryIterator parseAll(URL url, UniProtFactory factory, boolean ignoreWrongDR) {
        return new EntryIterator(factory, url, ignoreWrongDR);
    }
}

