/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.kraken.interfaces.factories.EntryFactory;
import uk.ac.ebi.kraken.parser.FastaParserException;

public abstract class KrakenFastaIterator<T>
implements Iterable<T>,
Iterator<T> {
    Logger logger = LoggerFactory.getLogger(KrakenFastaIterator.class);
    protected T entry;
    protected String fastaEntry;
    protected boolean quiet = false;
    protected Map<String, Exception> exceptionBucket;
    protected int maxEntriesInBucket = 1000;
    protected BufferedReader reader;
    public static final String ENTRY_START_TOKEN = ">";
    private String firstLine = "";
    private boolean available = true;
    private boolean isThefirstLine = true;
    StringBuilder newFileEntry;
    protected EntryFactory factory;

    public KrakenFastaIterator() {
    }

    public KrakenFastaIterator(EntryFactory factory, URL url) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
        this.factory = factory;
        this.init(in);
    }

    public KrakenFastaIterator(EntryFactory factory, File file) throws IOException {
        System.out.println("file.exists() = " + file.exists());
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        this.factory = factory;
        System.out.println("in. = " + in);
        this.init(in);
    }

    public KrakenFastaIterator(EntryFactory factory, InputStream inputStream) {
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
        this.factory = factory;
        this.init(in);
    }

    public KrakenFastaIterator(EntryFactory factory, Reader reader) {
        this.factory = factory;
        this.init(reader);
    }

    protected void init(Reader in) {
        this.reader = new BufferedReader(in);
        System.out.println("reader.toString() = " + this.reader.toString());
        this.exceptionBucket = new HashMap<String, Exception>();
    }

    @Override
    public boolean hasNext() {
        boolean answer = false;
        if (this.fastaEntry != null) {
            return true;
        }
        this.fastaEntry = this.getNextEntry();
        if (this.fastaEntry != null) {
            answer = true;
        }
        return answer;
    }

    @Override
    public T next() {
        T answer = null;
        if (this.fastaEntry != null) {
            answer = this.convertFastaEntry(this.fastaEntry);
        } else {
            this.fastaEntry = this.getNextEntry();
            if (this.fastaEntry != null) {
                answer = this.convertFastaEntry(this.fastaEntry);
            } else {
                throw new NoSuchElementException();
            }
        }
        this.fastaEntry = null;
        return answer;
    }

    private String getNextEntry() {
        try {
            this.newFileEntry = new StringBuilder();
            String newLine = "";
            if (this.isThefirstLine) {
                this.firstLine = this.reader.readLine();
                this.isThefirstLine = false;
            }
            this.newFileEntry.append(this.firstLine);
            if (this.available) {
                newLine = this.reader.readLine();
                if (!newLine.startsWith(ENTRY_START_TOKEN)) {
                    while (newLine != null && !newLine.startsWith(ENTRY_START_TOKEN)) {
                        this.newFileEntry.append('\n');
                        this.newFileEntry.append(newLine);
                        newLine = this.reader.readLine();
                    }
                    if (newLine == null) {
                        this.available = false;
                    } else {
                        this.firstLine = newLine;
                    }
                } else {
                    this.firstLine = newLine;
                }
            }
            if (this.newFileEntry.length() <= 0 || !this.available) {
                return null;
            }
            return this.newFileEntry.toString();
        }
        catch (IOException e) {
            throw new FastaParserException("Can't load Fastafile ", e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    protected abstract String getName();

    protected abstract T convertFastaEntry(String var1);

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public Map<String, Exception> getExceptionBucket() {
        return this.exceptionBucket;
    }

    public void setExceptionBucket(Map<String, Exception> exceptionBucket) {
        this.exceptionBucket = exceptionBucket;
    }

    public int getMaxEntriesInBucket() {
        return this.maxEntriesInBucket;
    }

    public void setMaxEntriesInBucket(int maxEntriesInBucket) {
        this.maxEntriesInBucket = maxEntriesInBucket;
    }
}

