/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import uk.ac.ebi.kraken.parser.LoaderException;

public class FlatFileLoader {
    public static final String ENTRY_END_TOKEN = "//";
    private BufferedReader reader;
    private boolean available = true;
    private String currentEntry = null;

    public FlatFileLoader(Reader reader) {
        this.reader = new BufferedReader(reader);
    }

    public String getNextEntry() {
        try {
            StringBuilder newFileEntry = new StringBuilder();
            String newLine = null;
            if (this.available) {
                do {
                    newLine = this.reader.readLine();
                    newFileEntry.append(newLine);
                    newFileEntry.append('\n');
                } while (newLine != null && !newLine.equals(ENTRY_END_TOKEN));
                if (newLine == null) {
                    this.available = false;
                }
            }
            if (newFileEntry.length() > 0) {
                this.currentEntry = newFileEntry.toString();
            }
            if (newFileEntry.length() <= 0 || !this.available) {
                return null;
            }
            return newFileEntry.toString();
        }
        catch (IOException e) {
            throw new LoaderException("Can't load Flatfile ", e);
        }
    }

    public String getCurrentPart() {
        return this.currentEntry;
    }

    public void close() throws IOException {
        this.reader.close();
    }
}

