/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.description;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Field;
import uk.ac.ebi.kraken.interfaces.uniprot.description.FieldType;
import uk.ac.ebi.kraken.interfaces.uniprot.description.Name;
import uk.ac.ebi.kraken.interfaces.uniprot.description.NameType;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;

public class NameImpl
implements Name {
    private NameType type;
    private List<Field> fields;
    private List<EvidenceId> evidenceIds;

    public NameImpl() {
        this.type = NameType.UNKNOWN;
        this.fields = new ArrayList<Field>();
        this.evidenceIds = new ArrayList<EvidenceId>();
    }

    public NameImpl(Name that) {
        this.type = that.getNameType();
        this.fields = new ArrayList<Field>();
        for (Field field : that.getFields()) {
            this.fields.add(DefaultUniProtFactory.getInstance().buildField(field));
        }
        this.evidenceIds = new ArrayList<EvidenceId>();
        for (EvidenceId evidenceId : this.evidenceIds) {
            this.evidenceIds.add(DefaultUniProtFactory.getInstance().buildEvidenceId(evidenceId));
        }
    }

    @Override
    public NameType getNameType() {
        return this.type;
    }

    @Override
    public void setNameType(NameType type) {
        this.type = type;
    }

    @Override
    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    @Override
    public List<Field> getFieldsByType(FieldType fieldType) {
        ArrayList<Field> returnFields = new ArrayList<Field>();
        for (Field field : this.fields) {
            if (field.getType() != fieldType) continue;
            returnFields.add(field);
        }
        return returnFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NameImpl that = (NameImpl)o;
        if (!this.fields.equals(that.fields)) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.fields.hashCode();
        return result;
    }

    public String toString() {
        return "NameImpl{type=" + (Object)((Object)this.type) + ", fields=" + this.fields + '}';
    }

    @Override
    public List<EvidenceId> getEvidenceIds() {
        return this.evidenceIds;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidences) {
        this.evidenceIds = evidences;
    }
}

