/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.dbx;

import uk.ac.ebi.kraken.interfaces.uniprot.DatabaseCrossReference;
import uk.ac.ebi.kraken.model.factories.DefaultXRefFactory;
import uk.ac.ebi.kraken.model.uniprot.accessions.UniProtIsoformIdImpl;

public class DatabaseXrefHelper {
    public static void setValue(DatabaseCrossReference dcr, int item, String value) {
        switch (item) {
            case 0: {
                dcr.setPrimaryId(DefaultXRefFactory.getInstance().buildXDBAttribute(value));
                break;
            }
            case 1: {
                dcr.setDescription(DefaultXRefFactory.getInstance().buildXDBAttribute(value));
                break;
            }
            case 2: {
                if (!dcr.hasThird() && !dcr.hasFourth()) break;
                dcr.setThird(DefaultXRefFactory.getInstance().buildXDBAttribute(value));
                break;
            }
            case 3: {
                if (!dcr.hasFourth()) break;
                dcr.setFourth(DefaultXRefFactory.getInstance().buildXDBAttribute(value));
                break;
            }
            case 4: {
                UniProtIsoformIdImpl iso = new UniProtIsoformIdImpl(value);
                dcr.setIsoformId(iso);
            }
        }
    }

    public static void setValues(DatabaseCrossReference dcr, String[] values) {
        for (int i = 0; i < values.length; ++i) {
            DatabaseXrefHelper.setValue(dcr, i, values[i]);
        }
    }

    public static String getValue(DatabaseCrossReference dcr, int item) {
        switch (item) {
            case 0: {
                return dcr.getPrimaryId().getValue();
            }
            case 1: {
                return dcr.getDescription().getValue();
            }
            case 2: {
                if (dcr.hasThird() || dcr.hasFourth()) {
                    return dcr.getThird().getValue();
                }
                return "";
            }
            case 3: {
                if (dcr.hasFourth()) {
                    return dcr.getFourth().getValue();
                }
                return "";
            }
            case 4: {
                if (dcr.getIsoformId() == null) break;
                return dcr.getIsoformId().getValue();
            }
        }
        return "";
    }
}

