/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Reaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.ReactionReference;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;

public class ReactionImpl
implements Reaction {
    private static final long serialVersionUID = 1L;
    private List<EvidenceId> evidences = new ArrayList<EvidenceId>();
    private String name;
    private List<ReactionReference> references = new ArrayList<ReactionReference>();
    private String ecNumber = "";

    @Override
    public List<EvidenceId> getEvidenceIds() {
        return this.evidences;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidences) {
        this.evidences.clear();
        this.evidences.addAll(evidences);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<ReactionReference> getReactionReferences() {
        return this.references;
    }

    @Override
    public void setReactionReferences(List<ReactionReference> references) {
        this.references.clear();
        this.references.addAll(references);
    }

    @Override
    public String getECNumber() {
        return this.ecNumber;
    }

    @Override
    public void setECNumber(String ec) {
        this.ecNumber = ec;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Reaction=").append(this.name).append(";");
        sb.append(" Xref=").append(this.references.stream().map(Object::toString).collect(Collectors.joining(", "))).append(";");
        if (this.ecNumber != null && !this.ecNumber.isEmpty()) {
            sb.append(" EC=").append(this.ecNumber).append(";");
        }
        if (!this.evidences.isEmpty()) {
            sb.append(" Evidence={").append(this.evidences.stream().map(val -> val.toString()).collect(Collectors.joining(", "))).append("};");
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ecNumber == null ? 0 : this.ecNumber.hashCode());
        result = 31 * result + (this.evidences == null ? 0 : this.evidences.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.references == null ? 0 : this.references.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReactionImpl other = (ReactionImpl)obj;
        if (this.ecNumber == null ? other.ecNumber != null : !this.ecNumber.equals(other.ecNumber)) {
            return false;
        }
        if (this.evidences == null ? other.evidences != null : !this.evidences.equals(other.evidences)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.references == null ? other.references != null : !this.references.equals(other.references));
    }
}

