/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Enzyme;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MaxVelocityUnit;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.MaximumVelocity;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;

public class MaximumVelocityImpl
implements MaximumVelocity,
PersistentObject {
    private long id;
    private float velocity;
    private Enzyme enzyme;
    private List<EvidenceId> evidenceIds;
    private MaxVelocityUnit velocityUnit;
    private String velocityStr = "";

    public MaximumVelocityImpl() {
        this.velocity = -1.0f;
        this.enzyme = DefaultUniProtFactory.getCommentFactory().buildEnzyme("");
        this.velocityUnit = DefaultCommentFactory.getInstance().buildMaxVelocityUnit("umol/h/mg");
    }

    public MaximumVelocityImpl(MaximumVelocity copy) {
        this.velocity = copy.getVelocity();
        this.velocityStr = copy.getVelocityStr();
        this.enzyme = DefaultCommentFactory.getInstance().buildEnzyme(copy.getEnzyme());
        this.evidenceIds = new ArrayList<EvidenceId>();
        for (EvidenceId id : copy.getEvidenceIds()) {
            this.evidenceIds.add(DefaultUniProtFactory.getEvidenceFactory().buildEvidenceId(id.getValue()));
        }
        this.setMaxVelocityUnit(DefaultCommentFactory.getInstance().buildMaxVelocityUnit(copy.getMaxVelocityUnit()));
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void setVelocity(float velocity) {
        this.velocity = velocity;
    }

    @Override
    public float getVelocity() {
        return this.velocity;
    }

    @Override
    public void setMaxVelocityUnit(MaxVelocityUnit unit) {
        this.velocityUnit = unit;
    }

    @Override
    public MaxVelocityUnit getMaxVelocityUnit() {
        return this.velocityUnit;
    }

    @Override
    public void setEnzyme(Enzyme enzyme) {
        if (enzyme == null) {
            throw new IllegalArgumentException();
        }
        this.enzyme = enzyme;
    }

    @Override
    public Enzyme getEnzyme() {
        return this.enzyme;
    }

    @Override
    public List<EvidenceId> getEvidenceIds() {
        if (this.evidenceIds == null) {
            this.evidenceIds = new ArrayList<EvidenceId>();
        }
        return this.evidenceIds;
    }

    @Override
    public void setEvidenceIds(List<EvidenceId> evidenceIds) {
        this.evidenceIds = evidenceIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaximumVelocityImpl that = (MaximumVelocityImpl)o;
        if (this.id != that.id) {
            return false;
        }
        if (Float.compare(that.velocity, this.velocity) != 0) {
            return false;
        }
        if (this.enzyme != null ? !this.enzyme.equals(that.enzyme) : that.enzyme != null) {
            return false;
        }
        if (this.evidenceIds != null && !this.evidenceIds.isEmpty() ? !this.evidenceIds.equals(that.evidenceIds) : that.evidenceIds != null && !that.evidenceIds.isEmpty()) {
            return false;
        }
        return this.velocityUnit.equals(that.velocityUnit);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = (float)(31 * result) + this.velocity != 0.0f ? Float.floatToIntBits(this.velocity) : 0;
        result = 31 * result + (this.velocityUnit != null ? this.velocityUnit.hashCode() : 0);
        result = 31 * result + (this.enzyme != null ? this.enzyme.hashCode() : 0);
        result = 31 * result + (this.evidenceIds != null && !this.evidenceIds.isEmpty() ? this.evidenceIds.hashCode() : 0);
        return result;
    }

    @Override
    public void setVelocityStr(String velocity) {
        this.velocityStr = velocity;
    }

    @Override
    public String getVelocityStr() {
        return this.velocityStr;
    }
}

