/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.Collection;
import java.util.Collections;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Interaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractionGeneName;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractionType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractorAccession;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.InteractorUniProtId;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.model.uniprot.CommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.InteractionGeneNameImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.InteractorAccessionImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.InteractorUniProtIdImpl;

public class InteractionImpl
extends CommentImpl
implements Interaction,
PersistentObject {
    public long id;
    private InteractionType interactionType;
    private InteractorUniProtId firstInteractant;
    private InteractorUniProtId secondInteractant;
    private InteractorUniProtId secondInteractantParent;
    private InteractionGeneName interactionGeneName;
    private int numberOfExperiments;
    private InteractorAccession firstInteractor;
    private InteractorAccession secondInteractor;

    public InteractionImpl() {
        this.interactionType = InteractionType.UNKNOWN;
        this.firstInteractant = new InteractorUniProtIdImpl();
        this.secondInteractant = new InteractorUniProtIdImpl();
        this.secondInteractantParent = new InteractorUniProtIdImpl();
        this.interactionGeneName = new InteractionGeneNameImpl();
        this.numberOfExperiments = -1;
        this.firstInteractor = new InteractorAccessionImpl();
        this.secondInteractor = new InteractorAccessionImpl();
    }

    public InteractionImpl(Interaction copy) {
        this.interactionType = copy.getInteractionType();
        this.firstInteractant = DefaultCommentFactory.getInstance().buildInteractorUniProtId(copy.getFirstInteractant());
        this.secondInteractant = DefaultCommentFactory.getInstance().buildInteractorUniProtId(copy.getSecondInteractant());
        this.secondInteractantParent = DefaultCommentFactory.getInstance().buildInteractorUniProtId(copy.getSecondInteractantParent());
        this.interactionGeneName = new InteractionGeneNameImpl();
        this.numberOfExperiments = -1;
        this.firstInteractor = new InteractorAccessionImpl();
        this.secondInteractor = new InteractorAccessionImpl();
        if (copy.getInteractionGeneName() != null) {
            this.interactionGeneName = DefaultCommentFactory.getInstance().buildInteractionGeneName(copy.getInteractionGeneName());
        }
        if (copy.getFirstInteractor() != null) {
            this.firstInteractor = DefaultCommentFactory.getInstance().buildIntActAccession(copy.getFirstInteractor());
        }
        if (copy.getSecondInteractor() != null) {
            this.secondInteractor = DefaultCommentFactory.getInstance().buildIntActAccession(copy.getSecondInteractor());
        }
        this.numberOfExperiments = copy.getNumberOfExperiments();
    }

    @Override
    public InteractorUniProtId getFirstInteractant() {
        return this.firstInteractant;
    }

    @Override
    public InteractorUniProtId getSecondInteractant() {
        return this.secondInteractant;
    }

    @Override
    public InteractorUniProtId getSecondInteractantParent() {
        return this.secondInteractantParent;
    }

    @Override
    public void setFirstInteractant(InteractorUniProtId firstInteractant) {
        this.firstInteractant = firstInteractant;
    }

    @Override
    public void setSecondInteractant(InteractorUniProtId secondInteractant) {
        this.secondInteractant = secondInteractant;
    }

    @Override
    public void setSecondInteractantParent(InteractorUniProtId secondInteractantParent) {
        this.secondInteractantParent = secondInteractantParent;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public String toString() {
        return "INTERACTION: " + this.firstInteractant.getValue() + "; " + this.secondInteractant.getValue() + "; " + this.firstInteractor + "-" + this.secondInteractor;
    }

    @Override
    public void setInteractionType(InteractionType interactionType) {
        this.interactionType = interactionType;
    }

    @Override
    public void setFirstInteractor(InteractorAccession acc) {
        this.firstInteractor = acc;
    }

    @Override
    public InteractorAccession getFirstInteractor() {
        return this.firstInteractor;
    }

    @Override
    public void setSecondInteractor(InteractorAccession acc) {
        this.secondInteractor = acc;
    }

    @Override
    public InteractorAccession getSecondInteractor() {
        return this.secondInteractor;
    }

    @Override
    public InteractionType getInteractionType() {
        return this.interactionType;
    }

    @Override
    public void setInteractionGeneName(InteractionGeneName interactionGeneName) {
        this.interactionGeneName = interactionGeneName;
    }

    @Override
    public InteractionGeneName getInteractionGeneName() {
        return this.interactionGeneName;
    }

    @Override
    public void setNumberOfExperiments(int number) {
        this.numberOfExperiments = number;
    }

    @Override
    public int getNumberOfExperiments() {
        return this.numberOfExperiments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InteractionImpl that = (InteractionImpl)o;
        if (this.numberOfExperiments != that.numberOfExperiments) {
            return false;
        }
        if (!this.firstInteractor.equals(that.firstInteractor)) {
            return false;
        }
        if (!this.interactionGeneName.equals(that.interactionGeneName)) {
            return false;
        }
        if (this.interactionType != that.interactionType) {
            return false;
        }
        if (!this.secondInteractor.equals(that.secondInteractor)) {
            return false;
        }
        if (!this.firstInteractant.equals(that.firstInteractant)) {
            return false;
        }
        if (!this.secondInteractant.equals(that.secondInteractant)) {
            return false;
        }
        return this.secondInteractantParent.equals(that.secondInteractantParent);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + this.interactionType.hashCode();
        result = 29 * result + this.firstInteractant.hashCode();
        result = 29 * result + this.secondInteractant.hashCode();
        result = 29 * result + this.secondInteractantParent.hashCode();
        result = 29 * result + this.interactionGeneName.hashCode();
        result = 29 * result + this.numberOfExperiments;
        result = 29 * result + this.firstInteractor.hashCode();
        result = 29 * result + this.secondInteractor.hashCode();
        return result;
    }

    @Override
    public CommentType getCommentType() {
        return CommentType.INTERACTION;
    }

    @Override
    public Collection<EvidenceId> collectEvidences() {
        return Collections.emptySet();
    }
}

