/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CatalyticActivityCommentStructured;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.CommentType;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.PhysiologicalReaction;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.Reaction;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.model.uniprot.CommentImpl;
import uk.ac.ebi.kraken.model.uniprot.comments.ReactionImpl;

public class CatalyticActivityCommentStructuredImpl
extends CommentImpl
implements CatalyticActivityCommentStructured {
    private static final long serialVersionUID = 1L;
    private Reaction reaction;
    private List<PhysiologicalReaction> physioReactions;

    public CatalyticActivityCommentStructuredImpl() {
        this.setCommentType(CommentType.CATALYTIC_ACTIVITY);
        this.reaction = new ReactionImpl();
        this.physioReactions = new ArrayList<PhysiologicalReaction>();
    }

    public CatalyticActivityCommentStructuredImpl(CatalyticActivityCommentStructured copy) {
        super(copy);
        this.setCommentType(CommentType.CATALYTIC_ACTIVITY);
        this.reaction = new ReactionImpl();
        this.physioReactions = new ArrayList<PhysiologicalReaction>();
        this.reaction.setName(copy.getReaction().getName());
        this.reaction.setECNumber(copy.getReaction().getECNumber());
        this.reaction.setEvidenceIds(copy.getReaction().getEvidenceIds());
        this.reaction.setReactionReferences(copy.getReaction().getReactionReferences());
        this.physioReactions.addAll(copy.getPhysiologicalReactions());
    }

    @Override
    public Reaction getReaction() {
        return this.reaction;
    }

    @Override
    public List<PhysiologicalReaction> getPhysiologicalReactions() {
        return this.physioReactions;
    }

    @Override
    public void setReaction(Reaction reaction) {
        this.reaction = reaction;
    }

    @Override
    public void setPhysiologicalReactions(List<PhysiologicalReaction> physiologicalReactions) {
        this.physioReactions.clear();
        this.physioReactions.addAll(physiologicalReactions);
    }

    @Override
    public Collection<EvidenceId> collectEvidences() {
        HashSet<EvidenceId> evidences = new HashSet<EvidenceId>();
        evidences.addAll(this.reaction.getEvidenceIds());
        this.physioReactions.stream().flatMap(val -> val.getEvidenceIds().stream()).forEach(val -> evidences.add((EvidenceId)val));
        return evidences;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.reaction.toString()).append("\n");
        for (PhysiologicalReaction pd : this.physioReactions) {
            sb.append(pd.toString()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.physioReactions == null ? 0 : this.physioReactions.hashCode());
        result = 31 * result + (this.reaction == null ? 0 : this.reaction.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CatalyticActivityCommentStructuredImpl other = (CatalyticActivityCommentStructuredImpl)obj;
        if (this.physioReactions == null ? other.physioReactions != null : !this.physioReactions.equals(other.physioReactions)) {
            return false;
        }
        return !(this.reaction == null ? other.reaction != null : !this.reaction.equals(other.reaction));
    }
}

