/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot.comments;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.AlternativeProductsIsoform;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformName;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformNote;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSequenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSequenceStatus;
import uk.ac.ebi.kraken.interfaces.uniprot.comments.IsoformSynonym;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultCommentFactory;
import uk.ac.ebi.kraken.util.NoNullElementsList;

public class AlternativeProductsIsoformImpl
implements AlternativeProductsIsoform,
PersistentObject {
    private static final long serialVersionUID = 1L;
    private IsoformName name;
    private IsoformNote note;
    private List<IsoformSynonym> synonyms;
    private List<IsoformId> ids;
    private List<IsoformSequenceId> sequenceIds;
    private IsoformSequenceStatus sequenceStatus;
    private long id;

    public AlternativeProductsIsoformImpl() {
        this.synonyms = new ArrayList<IsoformSynonym>();
        this.ids = new ArrayList<IsoformId>();
        this.sequenceIds = new ArrayList<IsoformSequenceId>();
        this.sequenceStatus = IsoformSequenceStatus.DESCRIBED;
        this.name = DefaultCommentFactory.getInstance().buildIsoformName();
        this.note = DefaultCommentFactory.getInstance().buildIsoformNote();
    }

    public AlternativeProductsIsoformImpl(AlternativeProductsIsoform copy) {
        this.synonyms = new NoNullElementsList<IsoformSynonym>(new ArrayList());
        this.ids = new NoNullElementsList<IsoformId>(new ArrayList());
        this.sequenceIds = new NoNullElementsList<IsoformSequenceId>(new ArrayList());
        this.sequenceStatus = IsoformSequenceStatus.DESCRIBED;
        this.name = DefaultCommentFactory.getInstance().buildIsoformName();
        this.note = DefaultCommentFactory.getInstance().buildIsoformNote();
        if (copy == null) {
            throw new IllegalArgumentException();
        }
        if (copy.hasName()) {
            this.name = DefaultCommentFactory.getInstance().buildIsoformName(copy.getName());
        }
        if (copy.hasNote()) {
            this.note = DefaultCommentFactory.getInstance().buildIsoformNote(copy.getNote());
        }
        this.synonyms = new NoNullElementsList<IsoformSynonym>(new ArrayList());
        for (IsoformSynonym isoformSynonym : copy.getSynonyms()) {
            this.synonyms.add(DefaultCommentFactory.getInstance().buildIsoformSynonym(isoformSynonym));
        }
        this.ids = new NoNullElementsList<IsoformId>(new ArrayList());
        for (IsoformId isoformId : copy.getIds()) {
            this.ids.add(DefaultCommentFactory.getInstance().buildIsoformId(isoformId));
        }
        this.sequenceIds = new NoNullElementsList<IsoformSequenceId>(new ArrayList());
        for (IsoformSequenceId isoformSequenceId : copy.getSequenceIds()) {
            this.sequenceIds.add(DefaultCommentFactory.getInstance().buildIsoformSequenceId(isoformSequenceId));
        }
        this.sequenceStatus = copy.getIsoformSequenceStatus();
    }

    @Override
    public IsoformName getName() {
        return this.name;
    }

    @Override
    public void setName(IsoformName name) {
        this.name = name;
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.getValue().equals("");
    }

    @Override
    public List<IsoformSynonym> getSynonyms() {
        return this.synonyms;
    }

    @Override
    public void setSynonyms(List<IsoformSynonym> synonyms) {
        if (synonyms == null) {
            throw new IllegalArgumentException();
        }
        this.synonyms = synonyms;
    }

    @Override
    public IsoformNote getNote() {
        return this.note;
    }

    @Override
    public void setNote(IsoformNote note) {
        this.note = note;
    }

    @Override
    public boolean hasNote() {
        return this.note != null && !this.note.getTexts().isEmpty();
    }

    @Override
    public List<IsoformId> getIds() {
        return this.ids;
    }

    @Override
    public void setIds(List<IsoformId> ids) {
        if (ids == null) {
            throw new IllegalArgumentException();
        }
        this.ids = ids;
    }

    @Override
    public List<IsoformSequenceId> getSequenceIds() {
        return this.sequenceIds;
    }

    @Override
    public void setSequenceIds(List<IsoformSequenceId> sequenceIds) {
        if (sequenceIds == null) {
            throw new IllegalArgumentException();
        }
        this.sequenceIds = sequenceIds;
    }

    @Override
    public IsoformSequenceStatus getIsoformSequenceStatus() {
        return this.sequenceStatus;
    }

    @Override
    public void setIsoformSequenceStatus(IsoformSequenceStatus status) {
        if (status == null) {
            throw new IllegalArgumentException();
        }
        this.sequenceStatus = status;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlternativeProductsIsoformImpl that = (AlternativeProductsIsoformImpl)o;
        if (!this.ids.equals(that.ids)) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.note != null ? !this.note.equals(that.note) : that.note != null) {
            return false;
        }
        if (!this.sequenceIds.equals(that.sequenceIds)) {
            return false;
        }
        if (this.sequenceStatus != that.sequenceStatus) {
            return false;
        }
        return this.synonyms.equals(that.synonyms);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 29 * result + (this.note != null ? this.note.hashCode() : 0);
        result = 29 * result + this.synonyms.hashCode();
        result = 29 * result + this.ids.hashCode();
        result = 29 * result + this.sequenceIds.hashCode();
        result = 29 * result + this.sequenceStatus.hashCode();
        return result;
    }
}

