/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.uniprot;

import java.util.Date;
import uk.ac.ebi.kraken.interfaces.uniprot.EntryAudit;
import uk.ac.ebi.kraken.model.annotations.IndexThisField;
import uk.ac.ebi.kraken.model.util.IndexField;

public class EntryAuditImpl
implements EntryAudit {
    private Date creationDate;
    private Date lastSequenceUpdateDate;
    private Date lastAnnotationUpdateDate;
    private Date firstPublicDate;
    private int sequenceVersion;
    private int entryVersion;

    public EntryAuditImpl() {
        this.creationDate = new Date(0L);
        this.lastSequenceUpdateDate = new Date(0L);
        this.lastAnnotationUpdateDate = new Date(0L);
        this.firstPublicDate = new Date(0L);
        this.sequenceVersion = 0;
        this.entryVersion = 0;
    }

    public EntryAuditImpl(EntryAudit copy) {
        this.creationDate = new Date(copy.getCreationDate().getTime());
        this.lastSequenceUpdateDate = new Date(copy.getLastSequenceUpdateDate().getTime());
        this.lastAnnotationUpdateDate = new Date(copy.getLastAnnotationUpdateDate().getTime());
        this.firstPublicDate = new Date(copy.getFirstPublicDate().getTime());
        this.sequenceVersion = copy.getSequenceVersion();
        this.entryVersion = copy.getEntryVersion();
    }

    @Override
    @Deprecated
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    @Deprecated
    public void setCreationDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException();
        }
        this.creationDate = date;
    }

    @Override
    public Date getLastSequenceUpdateDate() {
        return this.lastSequenceUpdateDate;
    }

    @Override
    public void setLastSequenceUpdateDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException();
        }
        this.lastSequenceUpdateDate = date;
    }

    @Override
    @IndexThisField(fieldName={IndexField.UPDATED_DATE})
    public Date getLastAnnotationUpdateDate() {
        return this.lastAnnotationUpdateDate;
    }

    @Override
    public void setLastAnnotationUpdateDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException();
        }
        this.lastAnnotationUpdateDate = date;
    }

    @Override
    @IndexThisField(fieldName={IndexField.CREATION_DATE})
    public Date getFirstPublicDate() {
        return this.firstPublicDate;
    }

    @Override
    public void setFirstPublicDate(Date firstPublicDate) {
        if (firstPublicDate == null) {
            throw new IllegalArgumentException();
        }
        this.firstPublicDate = firstPublicDate;
    }

    @Override
    public int getSequenceVersion() {
        return this.sequenceVersion;
    }

    @Override
    public void setSequenceVersion(int sequenceVersion) {
        this.sequenceVersion = sequenceVersion;
    }

    @Override
    public int getEntryVersion() {
        return this.entryVersion;
    }

    @Override
    public void setEntryVersion(int entryVersion) {
        this.entryVersion = entryVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntryAuditImpl that = (EntryAuditImpl)o;
        if (this.entryVersion != that.entryVersion) {
            return false;
        }
        if (this.sequenceVersion != that.sequenceVersion) {
            return false;
        }
        if (this.creationDate != null ? !this.creationDate.equals(that.creationDate) : that.creationDate != null) {
            return false;
        }
        if (this.firstPublicDate != null ? !this.firstPublicDate.equals(that.firstPublicDate) : that.firstPublicDate != null) {
            return false;
        }
        if (this.lastAnnotationUpdateDate != null ? !this.lastAnnotationUpdateDate.equals(that.lastAnnotationUpdateDate) : that.lastAnnotationUpdateDate != null) {
            return false;
        }
        return !(this.lastSequenceUpdateDate != null ? !this.lastSequenceUpdateDate.equals(that.lastSequenceUpdateDate) : that.lastSequenceUpdateDate != null);
    }

    public int hashCode() {
        int result = this.creationDate != null ? this.creationDate.hashCode() : 0;
        result = 31 * result + (this.lastSequenceUpdateDate != null ? this.lastSequenceUpdateDate.hashCode() : 0);
        result = 31 * result + (this.lastAnnotationUpdateDate != null ? this.lastAnnotationUpdateDate.hashCode() : 0);
        result = 31 * result + (this.firstPublicDate != null ? this.firstPublicDate.hashCode() : 0);
        result = 31 * result + this.sequenceVersion;
        result = 31 * result + this.entryVersion;
        return result;
    }
}

