/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.go;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import uk.ac.ebi.kraken.interfaces.go.GoId;
import uk.ac.ebi.kraken.interfaces.go.GoTerm;
import uk.ac.ebi.kraken.model.go.GoTermNode;

public class GoDAGLookup
implements Externalizable {
    private HashMap<GoId, GoTermNode> idToNode = new HashMap();

    public List<GoTerm> getIsAParents(GoTerm term) {
        GoTermNode termNode = this.idToNode.get(term.getGoId());
        List<GoId> ids = termNode.getIsAParents();
        return this.getTerms(ids);
    }

    public List<GoTerm> getPartOfAParents(GoTerm term) {
        GoTermNode termNode = this.idToNode.get(term.getGoId());
        List<GoId> ids = termNode.getPartOfAParents();
        return this.getTerms(ids);
    }

    public List<GoTerm> getIsAChildren(GoTerm term) {
        GoTermNode termNode = this.idToNode.get(term.getGoId());
        List<GoId> ids = termNode.getIsAChildren();
        return this.getTerms(ids);
    }

    public List<GoTerm> getPartOfChildren(GoTerm term) {
        GoTermNode termNode = this.idToNode.get(term.getGoId());
        List<GoId> ids = termNode.getPartOfChildren();
        return this.getTerms(ids);
    }

    public List<GoTerm> getAllIsAParents(GoTerm term) {
        ArrayList<GoId> ids = new ArrayList();
        GoTermNode termNode = this.idToNode.get(term.getGoId());
        if (termNode != null) {
            ids = termNode.getAllIsAParents();
        } else {
            System.err.println("GoDAGLookup: GoId not found! " + term);
        }
        return this.getTerms(ids);
    }

    public List<GoTerm> getAllIsAChildren(GoTerm term) {
        GoTermNode termNode = this.idToNode.get(term.getGoId());
        ArrayList<GoId> ids = new ArrayList<GoId>();
        this.addAllIsAChildren(termNode, ids);
        return this.getTerms(ids);
    }

    public GoTerm getGoTermForId(GoId id) {
        GoTermNode node = this.idToNode.get(id);
        if (node != null) {
            return node.getTerm();
        }
        return null;
    }

    public void addGoTermNode(GoTermNode node) {
        this.idToNode.put(node.getTerm().getGoId(), node);
    }

    public Set<GoId> getAllGoIds() {
        return this.idToNode.keySet();
    }

    public GoTermNode getGoTermNode(GoId id) {
        return this.idToNode.get(id);
    }

    private List<GoTerm> getTerms(List<GoId> ids) {
        ArrayList<GoTerm> terms = new ArrayList<GoTerm>(ids.size());
        for (GoId id : ids) {
            GoTermNode node = this.idToNode.get(id);
            if (node == null) continue;
            terms.add(node.getTerm());
        }
        return terms;
    }

    private void addAllIsAChildren(GoTermNode termNode, List<GoId> ids) {
        List<GoId> children = termNode.getIsAChildren();
        for (GoId multiChildId : children) {
            if (!ids.contains(multiChildId)) {
                ids.add(multiChildId);
            }
            GoTermNode childNode = this.getGoTermNode(multiChildId);
            this.addAllIsAChildren(childNode, ids);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.idToNode);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.idToNode = (HashMap)in.readObject();
    }
}

