/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.go;

import uk.ac.ebi.kraken.interfaces.go.GoAnnotation;
import uk.ac.ebi.kraken.interfaces.go.GoAnnotationEvidence;
import uk.ac.ebi.kraken.interfaces.go.GoEcoEvidence;
import uk.ac.ebi.kraken.interfaces.go.GoTerm;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtAccession;
import uk.ac.ebi.kraken.model.common.PersistentObject;
import uk.ac.ebi.kraken.model.factories.DefaultUniProtFactory;
import uk.ac.ebi.kraken.model.go.GoTermImpl;

public class GoAnnotationImpl
implements GoAnnotation,
PersistentObject {
    private GoTerm goTerm;
    private UniProtAccession uniProtAccession;
    private GoAnnotationEvidence evidence;
    private GoEcoEvidence goEcoEvidence;
    private long id;

    public GoAnnotationImpl() {
        this.goTerm = new GoTermImpl();
        this.uniProtAccession = DefaultUniProtFactory.getInstance().buildPrimaryUniProtAccession("");
        this.evidence = GoAnnotationEvidence.ND;
    }

    public GoAnnotationImpl(GoAnnotation goAnnotation) {
        this.goTerm = new GoTermImpl(goAnnotation.getGoTerm());
        this.uniProtAccession = DefaultUniProtFactory.getInstance().buildPrimaryUniProtAccession(goAnnotation.getUniProtAccession().getValue());
        this.evidence = goAnnotation.getEvidence();
    }

    @Override
    public GoTerm getGoTerm() {
        return this.goTerm;
    }

    @Override
    public void setGoTerm(GoTerm goTerm) {
        this.goTerm = goTerm;
    }

    @Override
    public UniProtAccession getUniProtAccession() {
        return this.uniProtAccession;
    }

    @Override
    public void setUniProtAccession(UniProtAccession uniProtAccession) {
        this.uniProtAccession = uniProtAccession;
    }

    @Override
    public GoAnnotationEvidence getEvidence() {
        return this.evidence;
    }

    @Override
    public void setEvidence(GoAnnotationEvidence evidence) {
        this.evidence = evidence;
    }

    @Override
    public GoEcoEvidence getEcoEvidence() {
        return this.goEcoEvidence;
    }

    @Override
    public void setGoEcoEvidence(GoEcoEvidence goEcoEvidence) {
        this.goEcoEvidence = goEcoEvidence;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GoAnnotationImpl)) {
            return false;
        }
        GoAnnotationImpl that = (GoAnnotationImpl)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.evidence != that.evidence) {
            return false;
        }
        if (!this.goEcoEvidence.equals(that.goEcoEvidence)) {
            return false;
        }
        if (!this.goTerm.equals(that.goTerm)) {
            return false;
        }
        return this.uniProtAccession.equals(that.uniProtAccession);
    }

    public int hashCode() {
        int result = this.goTerm.hashCode();
        result = 31 * result + this.uniProtAccession.hashCode();
        result = 31 * result + this.evidence.hashCode();
        result = 31 * result + this.goEcoEvidence.hashCode();
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public String toString() {
        return "GoAnnotationImpl{goTerm=" + this.goTerm + ", uniProtAccession=" + this.uniProtAccession + ", evidence=" + (Object)((Object)this.evidence) + '}';
    }
}

