/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.factories;

import uk.ac.ebi.kraken.interfaces.factories.GoFactory;
import uk.ac.ebi.kraken.interfaces.go.GoAnnotation;
import uk.ac.ebi.kraken.interfaces.go.GoAnnotationEvidence;
import uk.ac.ebi.kraken.interfaces.go.GoCategory;
import uk.ac.ebi.kraken.interfaces.go.GoEcoEvidence;
import uk.ac.ebi.kraken.interfaces.go.GoId;
import uk.ac.ebi.kraken.interfaces.go.GoTerm;
import uk.ac.ebi.kraken.interfaces.go.GoTermName;
import uk.ac.ebi.kraken.interfaces.go.toprotein.AssertedGoAnnotation;
import uk.ac.ebi.kraken.interfaces.go.toprotein.GoProteinContainer;
import uk.ac.ebi.kraken.interfaces.uniprot.UniProtAccession;
import uk.ac.ebi.kraken.model.go.GoAnnotationImpl;
import uk.ac.ebi.kraken.model.go.GoEcoEvidenceImpl;
import uk.ac.ebi.kraken.model.go.GoIdImpl;
import uk.ac.ebi.kraken.model.go.GoTermImpl;
import uk.ac.ebi.kraken.model.go.GoTermNameImpl;
import uk.ac.ebi.kraken.model.go.toprotein.AssertedGoAnnotationImpl;
import uk.ac.ebi.kraken.model.go.toprotein.GoProteinContainerImpl;

public class DefaultGoFactoryImpl
implements GoFactory {
    private static DefaultGoFactoryImpl instance = null;

    private DefaultGoFactoryImpl() {
    }

    public static DefaultGoFactoryImpl getInstance() {
        if (instance == null) {
            instance = new DefaultGoFactoryImpl();
        }
        return instance;
    }

    @Override
    public GoTerm buildGoTerm() {
        return new GoTermImpl();
    }

    @Override
    public GoTerm buildGoTerm(GoTerm copy) {
        return new GoTermImpl(copy);
    }

    @Override
    public GoTerm buildGoTerm(String id, GoCategory goCategory, String termName) {
        GoTermImpl term = new GoTermImpl();
        term.setGoId(this.buildGoId(id));
        term.setGoCategory(goCategory);
        term.setGoTermName(this.buildGoTermName(termName));
        return term;
    }

    @Override
    public GoId buildGoId(String id) {
        GoIdImpl goId = new GoIdImpl();
        goId.setValue(id);
        return goId;
    }

    @Override
    public GoTermName buildGoTermName(String name) {
        GoTermNameImpl termName = new GoTermNameImpl();
        termName.setValue(name);
        return termName;
    }

    @Override
    public GoEcoEvidence buildEcoEvidence(String ecoEvidence) {
        GoEcoEvidenceImpl evidence = new GoEcoEvidenceImpl();
        evidence.setValue(ecoEvidence);
        return evidence;
    }

    @Override
    public GoAnnotation buildGoAnnotation(UniProtAccession acc, GoTerm goTerm, GoEcoEvidence evidence) {
        GoAnnotationImpl annotation = new GoAnnotationImpl();
        annotation.setUniProtAccession(acc);
        annotation.setGoTerm(goTerm);
        annotation.setGoEcoEvidence(evidence);
        annotation.setEvidence(GoAnnotationEvidence.typeOfcvId(evidence.getValue()));
        return annotation;
    }

    @Override
    public AssertedGoAnnotation buildAssertedGoAnnotation(UniProtAccession acc, GoTerm goTerm, GoEcoEvidence evidence, boolean isAsserted) {
        AssertedGoAnnotationImpl annotation = new AssertedGoAnnotationImpl();
        annotation.setUniProtAccession(acc);
        annotation.setGoTerm(goTerm);
        annotation.setGoEcoEvidence(evidence);
        annotation.setEvidence(GoAnnotationEvidence.typeOfcvId(evidence.getValue()));
        annotation.setAsserted(isAsserted);
        return annotation;
    }

    @Override
    public GoProteinContainer buildGoProteinContainer(UniProtAccession acc) {
        GoProteinContainerImpl goProteinContainer = new GoProteinContainerImpl();
        goProteinContainer.setAccession(acc);
        return goProteinContainer;
    }
}

