/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.model.factories;

import uk.ac.ebi.kraken.interfaces.factories.EvidenceFactory;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.Evidence;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceAttribute;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceId;
import uk.ac.ebi.kraken.interfaces.uniprot.evidences.EvidenceOriginName;
import uk.ac.ebi.kraken.model.uniprot.evidences.EvidenceAttributeImpl;
import uk.ac.ebi.kraken.model.uniprot.evidences.EvidenceIdImpl;
import uk.ac.ebi.kraken.model.uniprot.evidences.EvidenceImpl;
import uk.ac.ebi.kraken.model.uniprot.evidences.EvidenceOriginNameImpl;

public class DefaultEvidenceFactory
implements EvidenceFactory {
    private static DefaultEvidenceFactory singletonInstance;

    protected DefaultEvidenceFactory() {
    }

    public static DefaultEvidenceFactory getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new DefaultEvidenceFactory();
        }
        return singletonInstance;
    }

    @Override
    public Evidence buildEvidence() {
        return new EvidenceImpl();
    }

    @Override
    public Evidence buildEvidence(Evidence copy) {
        return new EvidenceImpl(copy);
    }

    @Override
    public EvidenceAttribute buildEvidenceAttribute() {
        return new EvidenceAttributeImpl();
    }

    @Override
    public EvidenceAttribute buildEvidenceAttribute(String value) {
        EvidenceAttribute attribute = this.buildEvidenceAttribute();
        attribute.setValue(value);
        return attribute;
    }

    @Override
    public EvidenceOriginName buildEvidenceOriginName() {
        return new EvidenceOriginNameImpl();
    }

    @Override
    public EvidenceOriginName buildEvidenceOriginName(String value) {
        EvidenceOriginNameImpl originName = new EvidenceOriginNameImpl();
        originName.setValue(value);
        return originName;
    }

    @Override
    public EvidenceId buildEvidenceId() {
        return this.buildEvidenceId("");
    }

    @Override
    public EvidenceId buildEvidenceId(String value) {
        EvidenceIdImpl result = new EvidenceIdImpl();
        result.setValue(value);
        return result;
    }
}

