/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.kraken.ffwriter.line.impl.rlines;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.kraken.ffwriter.LineType;
import uk.ac.ebi.kraken.ffwriter.line.impl.rlines.RLine;
import uk.ac.ebi.kraken.interfaces.uniprot.citationsNew.CitationXrefs;

public class RXLineBuilder
implements RLine<CitationXrefs> {
    private static final String LINE_PREFIX = (Object)((Object)LineType.RX) + "   ";
    private static final String PUBMED = "PubMed=";
    private static final String AGRICOLA = "AGRICOLA=";
    private static final String DOI = "DOI=";

    private void addItem(StringBuilder sb, String name, String value, boolean includeFFMarkup) {
        if (value.isEmpty()) {
            return;
        }
        if (sb.length() == 0) {
            if (includeFFMarkup) {
                sb.append(LINE_PREFIX);
            }
        } else {
            sb.append(" ");
        }
        sb.append(name);
        sb.append(value);
        sb.append(";");
    }

    @Override
    public List<String> buildLine(CitationXrefs xrefs, boolean includeFFMarkup, boolean showEvidence) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        this.addItem(line, PUBMED, xrefs.getPubmedId().getValue(), includeFFMarkup);
        if (!xrefs.getAgricolaId().getValue().isEmpty()) {
            if (line.length() > 0 && xrefs.getAgricolaId().getValue().length() + AGRICOLA.length() + line.length() >= 79) {
                lines.add(line.toString());
                line = new StringBuilder();
            }
            this.addItem(line, AGRICOLA, xrefs.getAgricolaId().getValue(), includeFFMarkup);
        }
        if (!xrefs.getDOI().getValue().isEmpty()) {
            if (line.length() > 0 && xrefs.getDOI().getValue().length() + DOI.length() + line.length() >= 79) {
                lines.add(line.toString());
                line = new StringBuilder();
            }
            this.addItem(line, DOI, xrefs.getDOI().getValue(), includeFFMarkup);
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        return lines;
    }
}

